/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.tx;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapperImpl;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.InternalTxOptions;
import org.apache.ignite3.internal.tx.TxManager;
import org.jetbrains.annotations.Nullable;

public class QueryTransactionContextImpl
implements QueryTransactionContext {
    private final TxManager txManager;
    private final HybridTimestampTracker observableTimeTracker;
    @Nullable
    private final QueryTransactionWrapper tx;
    private final TransactionalOperationTracker txTracker;

    public QueryTransactionContextImpl(TxManager txManager, HybridTimestampTracker observableTimeTracker, @Nullable InternalTransaction tx, TransactionalOperationTracker txTracker) {
        this.txManager = txManager;
        this.observableTimeTracker = observableTimeTracker;
        this.tx = tx != null ? new QueryTransactionWrapperImpl(tx, false, txTracker) : null;
        this.txTracker = txTracker;
    }

    @Override
    public QueryTransactionWrapper getOrStartSqlManaged(boolean readOnly, boolean implicit) {
        QueryTransactionWrapper result;
        InternalTransaction transaction;
        if (this.tx == null) {
            transaction = implicit ? this.txManager.beginImplicit(this.observableTimeTracker, readOnly) : this.txManager.beginExplicit(this.observableTimeTracker, readOnly, InternalTxOptions.defaults());
            result = new QueryTransactionWrapperImpl(transaction, true, this.txTracker);
        } else {
            transaction = this.tx.unwrap();
            result = this.tx;
        }
        this.txTracker.registerOperationStart(transaction);
        return result;
    }

    @Override
    public void updateObservableTime(HybridTimestamp time) {
        this.observableTimeTracker.update(time);
    }

    @Override
    @Nullable
    public QueryTransactionWrapper explicitTx() {
        return this.tx;
    }
}

