/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.index;

import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.storage.index.IndexRow;
import org.apache.ignite3.internal.storage.index.PeekCursor;
import org.apache.ignite3.internal.storage.index.SortedIndexStorage;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.index.ThreadAssertingIndexStorage;
import org.apache.ignite3.internal.storage.index.ThreadAssertingPeekCursor;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.worker.ThreadAssertingCursor;
import org.apache.ignite3.internal.worker.ThreadAssertions;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingSortedIndexStorage
extends ThreadAssertingIndexStorage
implements SortedIndexStorage {
    private final SortedIndexStorage indexStorage;

    public ThreadAssertingSortedIndexStorage(SortedIndexStorage indexStorage) {
        super(indexStorage);
        this.indexStorage = indexStorage;
    }

    @Override
    public StorageSortedIndexDescriptor indexDescriptor() {
        return this.indexStorage.indexDescriptor();
    }

    @Override
    public PeekCursor<IndexRow> scan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingPeekCursor<IndexRow>(this.indexStorage.scan(lowerBound, upperBound, flags));
    }

    @Override
    public Cursor<IndexRow> readOnlyScan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor<IndexRow>(this.indexStorage.readOnlyScan(lowerBound, upperBound, flags));
    }

    @Override
    public PeekCursor<IndexRow> tolerantScan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingPeekCursor<IndexRow>(this.indexStorage.tolerantScan(lowerBound, upperBound, flags));
    }
}

