/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.pagememory.io.IoVersions;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.persistence.io.PartitionMetaIo;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.jetbrains.annotations.Nullable;

public class StoragePartitionMetaIo
extends PartitionMetaIo {
    public static final short T_TABLE_PARTITION_META_IO = 7;
    private static final int LAST_APPLIED_INDEX_OFF = 44;
    private static final int LAST_APPLIED_TERM_OFF = 52;
    private static final int LAST_REPLICATION_PROTOCOL_GROUP_CONFIG_FIRST_PAGE_ID_OFF = 60;
    private static final int FREE_LIST_ROOT_PAGE_ID_OFF = 68;
    private static final int VERSION_CHAIN_TREE_ROOT_PAGE_ID_OFF = 76;
    private static final int INDEX_TREE_META_PAGE_ID_OFF = 84;
    private static final int GC_QUEUE_META_PAGE_ID_OFF = 92;
    private static final int LEASE_START_TIME_OFF = 100;
    private static final int PRIMARY_REPLICA_NODE_ID_HIGH_OFF = 108;
    private static final int PRIMARY_REPLICA_NODE_ID_LOW_OFF = 116;
    private static final int PRIMARY_REPLICA_NODE_NAME_FIRST_PAGE_ID_OFF = 124;
    private static final int ESTIMATED_SIZE_OFF = 132;
    public static final IoVersions<StoragePartitionMetaIo> VERSIONS = new IoVersions((PageIo[])new StoragePartitionMetaIo[]{new StoragePartitionMetaIo(1)});

    protected StoragePartitionMetaIo(int ver) {
        super(7, ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setLastAppliedIndex(pageAddr, 0L);
        this.setLastAppliedTerm(pageAddr, 0L);
        this.setLastReplicationProtocolGroupConfigFirstPageId(pageAddr, 0L);
        this.setFreeListRootPageId(pageAddr, 0L);
        this.setVersionChainTreeRootPageId(pageAddr, 0L);
        this.setIndexTreeMetaPageId(pageAddr, 0L);
        this.setGcQueueMetaPageId(pageAddr, 0L);
        this.setPageCount(pageAddr, 0);
        this.setLeaseStartTime(pageAddr, HybridTimestamp.MIN_VALUE.longValue());
        this.setPrimaryReplicaNodeId(pageAddr, new UUID(0L, 0L));
        this.setPrimaryReplicaNodeNameFirstPageId(pageAddr, 0L);
        this.setEstimatedSize(pageAddr, 0L);
    }

    public void setLastAppliedIndex(long pageAddr, long lastAppliedIndex) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 44, lastAppliedIndex);
    }

    public void setLastAppliedTerm(long pageAddr, long lastAppliedTerm) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 52, lastAppliedTerm);
    }

    public void setLastReplicationProtocolGroupConfigFirstPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 60, pageId);
    }

    public long getLastAppliedIndex(long pageAddr) {
        return PageUtils.getLong(pageAddr, 44);
    }

    public long getLastAppliedTerm(long pageAddr) {
        return PageUtils.getLong(pageAddr, 52);
    }

    public long getLastReplicationProtocolGroupConfigFirstPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 60);
    }

    public void setFreeListRootPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 68, pageId);
    }

    public static long getFreeListRootPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 68);
    }

    public void setVersionChainTreeRootPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 76, pageId);
    }

    public long getVersionChainTreeRootPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 76);
    }

    public void setIndexTreeMetaPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 84, pageId);
    }

    public long getIndexTreeMetaPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 84);
    }

    public void setGcQueueMetaPageId(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 92, pageId);
    }

    public long getGcQueueMetaPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 92);
    }

    public void setLeaseStartTime(long pageAddr, long leaseStartTime) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 100, leaseStartTime);
    }

    public long getLeaseStartTime(long pageAddr) {
        return PageUtils.getLong(pageAddr, 100);
    }

    public void setPrimaryReplicaNodeId(long pageAddr, @Nullable UUID primaryReplicaNodeId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 108, primaryReplicaNodeId == null ? 0L : primaryReplicaNodeId.getMostSignificantBits());
        PageUtils.putLong(pageAddr, 116, primaryReplicaNodeId == null ? 0L : primaryReplicaNodeId.getLeastSignificantBits());
    }

    @Nullable
    public UUID getPrimaryReplicaNodeId(long pageAddr) {
        long high = PageUtils.getLong(pageAddr, 108);
        long low = PageUtils.getLong(pageAddr, 116);
        if (high == 0L && low == 0L && this.getPrimaryReplicaNodeNameFirstPageId(pageAddr) == 0L) {
            return null;
        }
        return new UUID(high, low);
    }

    public void setPrimaryReplicaNodeNameFirstPageId(long pageAddr, long primaryReplicaNodeNameFirstPageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 124, primaryReplicaNodeNameFirstPageId);
    }

    public long getPrimaryReplicaNodeNameFirstPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 124);
    }

    public void setEstimatedSize(long pageAddr, long estimatedSize) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 132, estimatedSize);
    }

    public long getEstimatedSize(long pageAddr) {
        return PageUtils.getLong(pageAddr, 132);
    }

    @Override
    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("TablePartitionMeta [").nl().app("lastAppliedIndex=").app(this.getLastAppliedIndex(addr)).nl().app("lastAppliedTerm=").app(this.getLastAppliedTerm(addr)).nl().app("lastReplicationProtocolGroupConfigFirstPageId=").app(this.getLastReplicationProtocolGroupConfigFirstPageId(addr)).nl().app("freeListRootPageId=").appendHex(StoragePartitionMetaIo.getFreeListRootPageId(addr)).nl().app("versionChainTreeRootPageId=").appendHex(this.getVersionChainTreeRootPageId(addr)).nl().app("indexTreeMetaPageId=").appendHex(this.getIndexTreeMetaPageId(addr)).nl().app("gcQueueMetaPageId=").appendHex(this.getGcQueueMetaPageId(addr)).nl().app("pageCount=").app(this.getPageCount(addr)).nl().app("leaseStartTime=").app(this.getLeaseStartTime(addr)).nl().app("primaryReplicaNodeId=").app(this.getPrimaryReplicaNodeId(addr)).nl().app("primaryReplicaNodeNameFirstPageId=").app(this.getPrimaryReplicaNodeNameFirstPageId(addr)).nl().app("estimatedSize=").app(this.getEstimatedSize(addr)).nl().app(']');
    }
}

