/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.lang.ErrorGroups;
import org.rocksdb.RocksDBException;
import org.rocksdb.Status;

public class IgniteRocksDbException
extends StorageException {
    public IgniteRocksDbException(RocksDBException cause) {
        super(IgniteRocksDbException.parseErrorCode(cause), (Throwable)cause);
    }

    public IgniteRocksDbException(String message, RocksDBException cause) {
        super(IgniteRocksDbException.parseErrorCode(cause), message, (Throwable)cause);
    }

    public IgniteRocksDbException(String message, RocksDBException cause, Object ... params) {
        super(IgniteRocksDbException.parseErrorCode(cause), message, cause, params);
    }

    private static int parseErrorCode(RocksDBException ex) {
        Status status = ex.getStatus();
        if (status != null && status.getCode() == Status.Code.Corruption) {
            return ErrorGroups.Storage.STORAGE_CORRUPTED_ERR;
        }
        return ErrorGroups.Common.INTERNAL_ERR;
    }
}

