/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb.instance;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.rocksdb.RocksUtils;
import org.apache.ignite3.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite3.internal.storage.StorageClosedException;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.rocksdb.ColumnFamilyUtils;
import org.apache.ignite3.internal.storage.rocksdb.IgniteRocksDbException;
import org.apache.ignite3.internal.storage.rocksdb.IndexIdCursor;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageEngine;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite3.internal.storage.rocksdb.instance.IndexColumnFamily;
import org.apache.ignite3.internal.storage.rocksdb.instance.SharedRocksDbInstanceCreator;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public final class SharedRocksDbInstance {
    public static final WriteOptions DFLT_WRITE_OPTS = new WriteOptions().setDisableWAL(true);
    public final RocksDbStorageEngine engine;
    public final Path path;
    public final RocksDbFlusher flusher;
    public final RocksDB db;
    public final RocksDbMetaStorage meta;
    public final ColumnFamily partitionCf;
    public final ColumnFamily gcQueueCf;
    public final ColumnFamily dataCf;
    private final ColumnFamily hashIndexCf;
    private final ConcurrentMap<ByteArray, SortedIndexColumnFamily> sortedIndexCfsByName = new ConcurrentHashMap<ByteArray, SortedIndexColumnFamily>();
    private final IgniteSpinBusyLock busyLock;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final List<AutoCloseable> resources;

    SharedRocksDbInstance(RocksDbStorageEngine engine, Path path, IgniteSpinBusyLock busyLock, RocksDbFlusher flusher, RocksDB db, RocksDbMetaStorage meta, ColumnFamily partitionCf, ColumnFamily gcQueueCf, ColumnFamily dataCf, ColumnFamily hashIndexCf, List<ColumnFamily> sortedIndexCfs, List<AutoCloseable> resources) {
        this.engine = engine;
        this.path = path;
        this.busyLock = busyLock;
        this.flusher = flusher;
        this.db = db;
        this.meta = meta;
        this.partitionCf = partitionCf;
        this.gcQueueCf = gcQueueCf;
        this.dataCf = dataCf;
        this.hashIndexCf = hashIndexCf;
        this.resources = new ArrayList<AutoCloseable>(resources);
        this.recoverExistingSortedIndexes(sortedIndexCfs);
    }

    private void recoverExistingSortedIndexes(List<ColumnFamily> sortedIndexCfs) {
        for (ColumnFamily sortedIndexCf : sortedIndexCfs) {
            HashMap<Integer, Integer> indexIdToTableId = new HashMap<Integer, Integer>();
            try (IndexIdCursor sortedIndexIdCursor = new IndexIdCursor(sortedIndexCf.newIterator(), null);){
                for (IndexIdCursor.TableAndIndexId tableAndIndexId : sortedIndexIdCursor) {
                    indexIdToTableId.put(tableAndIndexId.indexId(), tableAndIndexId.tableId());
                }
            }
            if (indexIdToTableId.isEmpty()) {
                this.destroyColumnFamily(sortedIndexCf);
                continue;
            }
            this.sortedIndexCfsByName.put(new ByteArray(sortedIndexCf.nameBytes()), new SortedIndexColumnFamily(sortedIndexCf, indexIdToTableId));
        }
    }

    public static void deleteByPrefix(WriteBatch writeBatch, ColumnFamily columnFamily, byte[] prefix) throws RocksDBException {
        byte[] upperBound = RocksUtils.incrementPrefix(prefix);
        writeBatch.deleteRange(columnFamily.handle(), prefix, upperBound);
    }

    public void stop() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        int expectedSize = this.sortedIndexCfsByName.size();
        ArrayList<ColumnFamilyOptions> sortedIndexOptions = new ArrayList<ColumnFamilyOptions>(expectedSize);
        ArrayList<ColumnFamilyHandle> sortedIndexHandles = new ArrayList<ColumnFamilyHandle>(expectedSize);
        for (SortedIndexColumnFamily sortedIndexCf : this.sortedIndexCfsByName.values()) {
            ColumnFamily cf = sortedIndexCf.columnFamily;
            sortedIndexHandles.add(cf.handle());
            @Nullable ColumnFamilyOptions options = cf.privateOptions();
            if (options == null) continue;
            sortedIndexOptions.add(cf.privateOptions());
        }
        this.resources.addAll(0, sortedIndexOptions);
        this.resources.addAll(sortedIndexHandles);
        this.resources.add(this.flusher::stop);
        try {
            Collections.reverse(this.resources);
            IgniteUtils.closeAll(this.resources);
        }
        catch (Exception e) {
            throw new StorageException("Failed to stop RocksDB storage: " + this.path, (Throwable)e);
        }
    }

    public ColumnFamily hashIndexCf() {
        return this.hashIndexCf;
    }

    /*
     * Exception decompiling
     */
    public Collection<Integer> hashIndexIds(int tableId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<IndexColumnFamily> sortedIndexes(int targetTableId) {
        ArrayList<IndexColumnFamily> result = new ArrayList<IndexColumnFamily>();
        for (SortedIndexColumnFamily indexCf : this.sortedIndexCfsByName.values()) {
            indexCf.indexIdToTableId.forEach((indexId, tableId) -> {
                if (tableId == targetTableId) {
                    result.add(new IndexColumnFamily((int)indexId, indexCf.columnFamily));
                }
            });
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnFamily getOrCreateSortedIndexCf(byte[] cfName, int indexId, int tableId) {
        if (!this.busyLock.enterBusy()) {
            throw new StorageClosedException();
        }
        try {
            SortedIndexColumnFamily result = this.sortedIndexCfsByName.compute(new ByteArray(cfName), (unused, sortedIndexCf) -> {
                if (sortedIndexCf == null) {
                    sortedIndexCf = new SortedIndexColumnFamily(this.createSortedIndexCf(cfName));
                }
                sortedIndexCf.indexIdToTableId.put(indexId, tableId);
                return sortedIndexCf;
            });
            ColumnFamily columnFamily = result.columnFamily;
            return columnFamily;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void removeSortedIndex(int indexId, ColumnFamily cf) {
        ByteArray cfNameBytes = new ByteArray(cf.nameBytes());
        this.sortedIndexCfsByName.computeIfPresent(cfNameBytes, (unused, indexCf) -> {
            indexCf.indexIdToTableId.remove(indexId);
            return indexCf;
        });
    }

    public CompletableFuture<Void> scheduleIndexCfsDestroyIfNeeded(List<ColumnFamily> columnFamilies) {
        assert (!columnFamilies.isEmpty());
        return this.flusher.awaitFlush(false).thenRunAsync(() -> {
            if (!this.busyLock.enterBusy()) {
                throw new StorageClosedException();
            }
            try {
                columnFamilies.forEach(this::destroySortedIndexCfIfNeeded);
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }, this.engine.threadPool());
    }

    void destroySortedIndexCfIfNeeded(ColumnFamily columnFamily) {
        ByteArray cfNameBytes = new ByteArray(columnFamily.nameBytes());
        this.sortedIndexCfsByName.computeIfPresent(cfNameBytes, (unused, indexCf) -> {
            if (!indexCf.indexIdToTableId.isEmpty()) {
                return indexCf;
            }
            this.destroyColumnFamily(indexCf.columnFamily);
            return null;
        });
    }

    public void destroyTable(int targetTableId) {
        try (WriteBatch writeBatch = new WriteBatch();){
            byte[] tableIdBytes = ByteBuffer.allocate(4).order(RocksDbStorageUtils.KEY_BYTE_ORDER).putInt(targetTableId).array();
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.partitionCf, tableIdBytes);
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.dataCf, tableIdBytes);
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.gcQueueCf, tableIdBytes);
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.hashIndexCf, tableIdBytes);
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.meta.columnFamily(), SharedRocksDbInstance.metaPrefix(RocksDbMetaStorage.PARTITION_META_PREFIX, tableIdBytes));
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.meta.columnFamily(), SharedRocksDbInstance.metaPrefix(RocksDbMetaStorage.PARTITION_CONF_PREFIX, tableIdBytes));
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.meta.columnFamily(), SharedRocksDbInstance.metaPrefix(RocksDbMetaStorage.INDEX_ROW_ID_PREFIX, tableIdBytes));
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.meta.columnFamily(), SharedRocksDbInstance.metaPrefix(RocksDbMetaStorage.LEASE_PREFIX, tableIdBytes));
            SharedRocksDbInstance.deleteByPrefix(writeBatch, this.meta.columnFamily(), SharedRocksDbInstance.metaPrefix(RocksDbMetaStorage.ESTIMATED_SIZE_PREFIX, tableIdBytes));
            ArrayList<ColumnFamily> cfsToRemove = new ArrayList<ColumnFamily>();
            for (SortedIndexColumnFamily indexCf : this.sortedIndexCfsByName.values()) {
                Iterator<Integer> it = indexCf.indexIdToTableId.values().iterator();
                while (it.hasNext()) {
                    int tableId = it.next();
                    if (targetTableId != tableId) continue;
                    it.remove();
                    SharedRocksDbInstance.deleteByPrefix(writeBatch, indexCf.columnFamily, tableIdBytes);
                    cfsToRemove.add(indexCf.columnFamily);
                }
            }
            this.db.write(DFLT_WRITE_OPTS, writeBatch);
            if (!cfsToRemove.isEmpty()) {
                this.scheduleIndexCfsDestroyIfNeeded(cfsToRemove);
            }
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(String.format("Failed to destroy table data. [tableId=%d]", targetTableId), e);
        }
    }

    private static byte[] metaPrefix(byte[] metaPrefix, byte[] tableIdBytes) {
        return ByteBuffer.allocate(metaPrefix.length + tableIdBytes.length).order(RocksDbStorageUtils.KEY_BYTE_ORDER).put(metaPrefix).put(tableIdBytes).array();
    }

    private ColumnFamily createSortedIndexCf(byte[] cfName) {
        ColumnFamily columnFamily;
        ColumnFamilyOptions cfOptions = SharedRocksDbInstanceCreator.sortedIndexCfOptions(cfName);
        this.resources.add(0, (AutoCloseable)cfOptions);
        ColumnFamilyDescriptor cfDescriptor = new ColumnFamilyDescriptor(cfName, cfOptions);
        try {
            columnFamily = ColumnFamily.withPrivateOptions(this.db, cfDescriptor);
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException("Failed to create new RocksDB column family: " + ColumnFamilyUtils.toStringName(cfName), e);
        }
        this.flusher.addColumnFamily(columnFamily.handle());
        return columnFamily;
    }

    private void destroyColumnFamily(ColumnFamily columnFamily) {
        this.flusher.removeColumnFamily(columnFamily.handle());
        try {
            columnFamily.destroy();
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(String.format("Failed to destroy RocksDB Column Family. [cfName=%s, path=%s]", columnFamily.name(), this.path), e);
        }
    }

    public Set<Integer> tableIdsOnDisk() {
        HashSet<Integer> tableIds = new HashSet<Integer>();
        try (Slice upperBound = new Slice(RocksUtils.incrementPrefix(RocksDbMetaStorage.PARTITION_META_PREFIX));
             ReadOptions readOptions = new ReadOptions().setIterateUpperBound((AbstractSlice)upperBound);
             RocksIterator it = this.meta.columnFamily().newIterator(readOptions);){
            it.seek(RocksDbMetaStorage.PARTITION_META_PREFIX);
            while (it.isValid()) {
                byte[] key = it.key();
                int tableId = ByteUtils.bytesToInt(key, RocksDbMetaStorage.PARTITION_META_PREFIX.length);
                tableIds.add(tableId);
                it.next();
            }
            it.status();
        }
        catch (RocksDBException e) {
            throw new StorageException(ErrorGroups.Common.INTERNAL_ERR, "Cannot get table IDs", e, new Object[0]);
        }
        return Set.copyOf(tableIds);
    }

    public CompletableFuture<Void> flush() {
        return this.flusher.awaitFlush(true);
    }

    private static class SortedIndexColumnFamily
    implements AutoCloseable {
        final ColumnFamily columnFamily;
        final Map<Integer, Integer> indexIdToTableId = new ConcurrentHashMap<Integer, Integer>();

        SortedIndexColumnFamily(ColumnFamily columnFamily) {
            this.columnFamily = columnFamily;
        }

        SortedIndexColumnFamily(ColumnFamily columnFamily, Map<Integer, Integer> indexIdToTableId) {
            this.columnFamily = columnFamily;
            this.indexIdToTableId.putAll(indexIdToTableId);
        }

        @Override
        public void close() {
            this.columnFamily.handle().close();
        }
    }
}

