/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.systemview.api;

import java.util.function.Function;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.util.StringUtils;

public class SystemViewColumn<T, C> {
    private final String name;
    private final Function<T, C> value;
    private final NativeType type;

    SystemViewColumn(String name, NativeType type, Function<T, C> value) {
        if (StringUtils.nullOrBlank(name)) {
            throw new IllegalArgumentException("Column name can not be null or blank");
        }
        if (type == null) {
            throw new IllegalArgumentException("Column type can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Column value can not be null");
        }
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public NativeType type() {
        return this.type;
    }

    public Function<T, C> value() {
        return this.value;
    }

    public String toString() {
        return S.toString(SystemViewColumn.class, this, "name", (Object)this.name, "type", (Object)this.type);
    }
}

