/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.Map;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite3.internal.table.AbstractClientStreamerPartitionAwarenessProvider;
import org.apache.ignite3.internal.util.ColocationUtils;
import org.apache.ignite3.internal.util.HashCalculator;
import org.apache.ignite3.lang.MarshallerException;

class KeyValuePojoStreamerPartitionAwarenessProvider<K, V>
extends AbstractClientStreamerPartitionAwarenessProvider<Map.Entry<K, V>> {
    private final KvMarshaller<K, V> marsh;

    KeyValuePojoStreamerPartitionAwarenessProvider(SchemaRegistry schemaReg, int partitions, KvMarshaller<K, V> marsh) {
        super(schemaReg, partitions);
        assert (marsh != null);
        this.marsh = marsh;
    }

    @Override
    int colocationHash(SchemaDescriptor schema, Map.Entry<K, V> item) throws MarshallerException {
        HashCalculator hashCalc = new HashCalculator();
        for (Column c : schema.colocationColumns()) {
            Object val = this.marsh.value(item.getKey(), c.positionInRow());
            ColocationUtils.append(hashCalc, val, c.type());
        }
        return hashCalc.hash();
    }
}

