/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.TableWriteIntentSwitchReplicaRequest;
import org.apache.ignite3.internal.tx.message.TableWriteIntentSwitchReplicaRequestBuilder;
import org.apache.ignite3.internal.tx.message.TableWriteIntentSwitchReplicaRequestSerializer;

public class TableWriteIntentSwitchReplicaRequestImpl
implements TableWriteIntentSwitchReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 21;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID txId;

    private TableWriteIntentSwitchReplicaRequestImpl(boolean commit, HybridTimestamp commitTimestamp, ReplicationGroupIdMessage groupId, int tableId, HybridTimestamp timestamp, UUID txId) {
        this.commit = commit;
        this.commitTimestamp = commitTimestamp;
        this.groupId = groupId;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return TableWriteIntentSwitchReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TableWriteIntentSwitchReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 21;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TableWriteIntentSwitchReplicaRequestImpl otherMessage = (TableWriteIntentSwitchReplicaRequestImpl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.tableId, this.commitTimestamp, this.groupId, this.timestamp, this.txId);
        return result;
    }

    @Override
    public TableWriteIntentSwitchReplicaRequestImpl clone() {
        try {
            return (TableWriteIntentSwitchReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TableWriteIntentSwitchReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements TableWriteIntentSwitchReplicaRequestBuilder {
        private boolean commit;
        private HybridTimestamp commitTimestamp;
        private ReplicationGroupIdMessage groupId;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID txId;

        private Builder() {
        }

        @Override
        public TableWriteIntentSwitchReplicaRequestBuilder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public TableWriteIntentSwitchReplicaRequestBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public TableWriteIntentSwitchReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public TableWriteIntentSwitchReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public TableWriteIntentSwitchReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public TableWriteIntentSwitchReplicaRequestBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public TableWriteIntentSwitchReplicaRequest build() {
            return new TableWriteIntentSwitchReplicaRequestImpl(this.commit, this.commitTimestamp, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.tableId, this.timestamp, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

