/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;
import org.apache.ignite3.internal.util.TrackerClosedException;
import org.jetbrains.annotations.Nullable;

public class SafeTimeValuesTracker
extends PendingComparableValuesTracker<HybridTimestamp, Void> {
    public SafeTimeValuesTracker(HybridTimestamp initialValue) {
        super(initialValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void update(HybridTimestamp newValue, @Nullable Void futureResult) {
        if (!this.enterBusy()) {
            throw new TrackerClosedException();
        }
        try {
             @Nullable Map.Entry current = this.current;
            IgniteBiTuple<HybridTimestamp, @Nullable Void> newEntry = new IgniteBiTuple<HybridTimestamp, Void>(newValue, futureResult);
            if (this.comparator.compare(newEntry, current) < 0) {
                throw new AssertionError((Object)("Reordering detected: [old=" + current.getKey() + ", new=" + newEntry.get1() + "]"));
            }
            CURRENT.set(this, newEntry);
            this.completeWaitersOnUpdate(newValue, futureResult);
        }
        finally {
            this.leaveBusy();
        }
    }
}

