/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.closure;

import java.util.concurrent.CountDownLatch;
import org.apache.ignite3.raft.jraft.Closure;
import org.apache.ignite3.raft.jraft.Status;

public class SynchronizedClosure
implements Closure {
    private CountDownLatch latch;
    private volatile Status status;
    private int count;

    public SynchronizedClosure() {
        this(1);
    }

    public SynchronizedClosure(int n) {
        this.count = n;
        this.latch = new CountDownLatch(n);
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public void run(Status status) {
        this.status = status;
        this.latch.countDown();
    }

    public Status await() throws InterruptedException {
        this.latch.await();
        return this.status;
    }

    public void reset() {
        this.status = null;
        this.latch = new CountDownLatch(this.count);
    }
}

