/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.core;

import org.apache.ignite3.raft.jraft.JRaftServiceFactory;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryCodecFactory;
import org.apache.ignite3.raft.jraft.entity.codec.v1.LogEntryV1CodecFactory;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.LogStorage;
import org.apache.ignite3.raft.jraft.storage.RaftMetaStorage;
import org.apache.ignite3.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite3.raft.jraft.storage.impl.LocalRaftMetaStorage;
import org.apache.ignite3.raft.jraft.storage.impl.RocksDBLogStorage;
import org.apache.ignite3.raft.jraft.storage.snapshot.local.LocalSnapshotStorage;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.StringUtils;
import org.apache.ignite3.raft.jraft.util.timer.DefaultRaftTimerFactory;
import org.apache.ignite3.raft.jraft.util.timer.RaftTimerFactory;

public class DefaultJRaftServiceFactory
implements JRaftServiceFactory {
    @Override
    public LogStorage createLogStorage(String uri, RaftOptions raftOptions) {
        Requires.requireTrue(StringUtils.isNotBlank(uri), "Blank log storage uri.");
        return new RocksDBLogStorage(uri, raftOptions);
    }

    @Override
    public SnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        Requires.requireTrue(!StringUtils.isBlank(uri), "Blank snapshot storage uri.");
        return new LocalSnapshotStorage(uri, raftOptions);
    }

    @Override
    public RaftMetaStorage createRaftMetaStorage(String uri, RaftOptions raftOptions) {
        Requires.requireTrue(!StringUtils.isBlank(uri), "Blank raft meta storage uri.");
        return new LocalRaftMetaStorage(uri, raftOptions);
    }

    @Override
    public LogEntryCodecFactory createLogEntryCodecFactory() {
        return LogEntryV1CodecFactory.getInstance();
    }

    @Override
    public RaftTimerFactory createRaftTimerFactory() {
        return new DefaultRaftTimerFactory();
    }
}

