/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.core;

import java.nio.ByteBuffer;
import java.util.function.BooleanSupplier;
import org.apache.ignite3.raft.jraft.Closure;
import org.apache.ignite3.raft.jraft.Iterator;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.core.IteratorImpl;
import org.apache.ignite3.raft.jraft.entity.EnumOutter;
import org.apache.ignite3.raft.jraft.entity.LogEntry;

public class IteratorWrapper
implements Iterator {
    private final IteratorImpl impl;
    private final BooleanSupplier shuttingDown;

    public IteratorWrapper(IteratorImpl iterImpl, BooleanSupplier shuttingDown) {
        this.impl = iterImpl;
        this.shuttingDown = shuttingDown;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorHasNext() && !this.shuttingDown.getAsBoolean();
    }

    private boolean iteratorHasNext() {
        return this.impl.isGood() && this.impl.entry().getType() == EnumOutter.EntryType.ENTRY_TYPE_DATA;
    }

    @Override
    public ByteBuffer next() {
        ByteBuffer data = this.getData();
        if (this.iteratorHasNext()) {
            this.impl.next();
        }
        return data;
    }

    @Override
    public ByteBuffer getData() {
        LogEntry entry = this.impl.entry();
        return entry != null ? entry.getData() : null;
    }

    @Override
    public long getIndex() {
        return this.impl.getIndex();
    }

    @Override
    public long getTerm() {
        return this.impl.entry().getId().getTerm();
    }

    @Override
    public Closure done() {
        return this.impl.done();
    }

    @Override
    public void setErrorAndRollback(long ntail, Status st) {
        this.impl.setErrorAndRollback(ntail, st);
    }
}

