/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.ErrorResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.ErrorResponseSerializer;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

public class ErrorResponseImpl
implements RpcRequests.ErrorResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3001;
    @IgniteToStringInclude
    private final int errorCode;
    @IgniteToStringInclude
    private final String errorMsg;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final Long maxObservableSafeTimeViolatedValue;

    private ErrorResponseImpl(int errorCode, String errorMsg, String leaderId, Long maxObservableSafeTimeViolatedValue) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.leaderId = leaderId;
        this.maxObservableSafeTimeViolatedValue = maxObservableSafeTimeViolatedValue;
    }

    @Override
    public int errorCode() {
        return this.errorCode;
    }

    @Override
    public String errorMsg() {
        return this.errorMsg;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public Long maxObservableSafeTimeViolatedValue() {
        return this.maxObservableSafeTimeViolatedValue;
    }

    public MessageSerializer serializer() {
        return ErrorResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ErrorResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3001;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ErrorResponseImpl otherMessage = (ErrorResponseImpl)other;
        return Objects.equals(this.errorMsg, otherMessage.errorMsg) && Objects.equals(this.leaderId, otherMessage.leaderId) && Objects.equals(this.maxObservableSafeTimeViolatedValue, otherMessage.maxObservableSafeTimeViolatedValue) && this.errorCode == otherMessage.errorCode;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.errorCode, this.errorMsg, this.leaderId, this.maxObservableSafeTimeViolatedValue);
        return result;
    }

    @Override
    public ErrorResponseImpl clone() {
        try {
            return (ErrorResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ErrorResponseBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ErrorResponseBuilder {
        private int errorCode;
        private String errorMsg;
        private String leaderId;
        private Long maxObservableSafeTimeViolatedValue;

        private Builder() {
        }

        @Override
        public ErrorResponseBuilder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public ErrorResponseBuilder errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        @Override
        public ErrorResponseBuilder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public ErrorResponseBuilder maxObservableSafeTimeViolatedValue(Long maxObservableSafeTimeViolatedValue) {
            this.maxObservableSafeTimeViolatedValue = maxObservableSafeTimeViolatedValue;
            return this;
        }

        @Override
        public int errorCode() {
            return this.errorCode;
        }

        @Override
        public String errorMsg() {
            return this.errorMsg;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public Long maxObservableSafeTimeViolatedValue() {
            return this.maxObservableSafeTimeViolatedValue;
        }

        @Override
        public RpcRequests.ErrorResponse build() {
            return new ErrorResponseImpl(this.errorCode, this.errorMsg, this.leaderId, this.maxObservableSafeTimeViolatedValue);
        }
    }
}

