/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc.impl.cli;

import java.util.List;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.Node;
import org.apache.ignite3.raft.jraft.NodeManager;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite3.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite3.raft.jraft.rpc.RpcRequestProcessor;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;
import org.apache.ignite3.raft.jraft.util.StringUtils;

public abstract class BaseCliRequestProcessor<T extends Message>
extends RpcRequestProcessor<T> {
    protected static final IgniteLogger LOG = Loggers.forClass(BaseCliRequestProcessor.class);

    public BaseCliRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    protected abstract String getPeerId(T var1);

    protected abstract String getGroupId(T var1);

    protected abstract Message processRequest0(CliRequestContext var1, T var2, IgniteCliRpcRequestClosure var3);

    @Override
    public Message processRequest(T request, RpcRequestClosure done) {
        String groupId = this.getGroupId(request);
        String peerIdStr = this.getPeerId(request);
        PeerId peerId = null;
        if (!StringUtils.isBlank(peerIdStr) && !(peerId = new PeerId()).parse(peerIdStr)) {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer: %s", peerIdStr);
        }
        Status st = new Status();
        Node node = this.getNode(groupId, peerId, st, done.getRpcCtx().getNodeManager());
        if (!st.isOk()) {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), st.getCode(), st.getErrorMsg(), new Object[0]);
        }
        return this.processRequest0(new CliRequestContext(node, groupId, peerId), request, new IgniteCliRpcRequestClosure(node, done));
    }

    protected Node getNode(String groupId, PeerId peerId, Status st, NodeManager nodeManager) {
        Node node = null;
        if (peerId != null) {
            node = nodeManager.get(groupId, peerId);
            if (node == null) {
                st.setError(RaftError.ENOENT, "Fail to find node %s in group %s", peerId, groupId);
            }
        } else {
            List<Node> nodes = nodeManager.getNodesByGroupId(groupId);
            if (nodes == null || nodes.isEmpty()) {
                st.setError(RaftError.ENOENT, "Empty nodes in group %s", groupId);
            } else if (nodes.size() > 1) {
                st.setError(RaftError.EINVAL, "Peer must be specified since there're %d nodes in group %s", nodes.size(), groupId);
            } else {
                node = nodes.get(0);
            }
        }
        if (node != null && node.getOptions().isDisableCli()) {
            st.setError(RaftError.EACCES, "Cli service is not allowed to access node %s", node.getNodeId());
        }
        return node;
    }

    public static class CliRequestContext {
        public final Node node;
        public final PeerId peerId;
        public final String groupId;

        public CliRequestContext(Node ndoe, String groupId, PeerId peerId) {
            this.node = ndoe;
            this.peerId = peerId;
            this.groupId = groupId;
        }
    }
}

