/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.raft.jraft.util.ByteBufferCollector;
import org.apache.ignite3.raft.jraft.util.ByteBufferCollectorPool;
import org.jetbrains.annotations.Nullable;

public class ConcurrentLinkedLifoByteBufferCollectorPool
implements ByteBufferCollectorPool {
    private final int capacity;
    private final AtomicReference<Node> stack = new AtomicReference();

    public ConcurrentLinkedLifoByteBufferCollectorPool(int capacity) {
        assert (capacity > 0) : capacity;
        this.capacity = capacity;
    }

    @Override
    @Nullable
    public ByteBufferCollector borrow() {
        Node node;
        do {
            if ((node = this.stack.get()) != null) continue;
            return null;
        } while (!this.stack.compareAndSet(node, node.next));
        return node.collector;
    }

    @Override
    public void release(ByteBufferCollector c) {
        int newIndex;
        Node node;
        do {
            int n = newIndex = (node = this.stack.get()) == null ? 0 : node.index + 1;
            if (newIndex != this.capacity) continue;
            return;
        } while (!this.stack.compareAndSet(node, new Node(c, newIndex, node)));
    }

    private static final class Node {
        private final ByteBufferCollector collector;
        private final int index;
        @Nullable
        private final Node next;

        private Node(ByteBufferCollector collector, int index, @Nullable Node next) {
            this.collector = collector;
            this.index = index;
            this.next = next;
        }
    }
}

