/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.exceptions;

import org.apache.ignite.migrationtools.cli.exceptions.DefaultMigrateCacheExceptionHandler;
import org.apache.ignite.migrationtools.cli.exceptions.RecordAndTableSchemaMismatchExceptionHandler;
import org.apache.ignite.migrationtools.persistence.exceptions.MigrateCacheException;
import org.apache.ignite.migrationtools.persistence.mappers.RecordAndTableSchemaMismatchException;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.table.DataStreamerException;

public class DataStreamerExceptionHandler
implements ExceptionHandler<DataStreamerException> {
    public int handle(ExceptionWriter writer, DataStreamerException e) {
        if (e.getCause() instanceof MigrateCacheException) {
            String details;
            MigrateCacheException mce = (MigrateCacheException)e.getCause();
            if (e.getCause().getCause() instanceof RecordAndTableSchemaMismatchException) {
                RecordAndTableSchemaMismatchException rme = (RecordAndTableSchemaMismatchException)mce.getCause();
                details = RecordAndTableSchemaMismatchExceptionHandler.details(rme);
            } else {
                details = "Unknown error. Check the logs folder for more information.";
            }
            writer.write(ErrorUiComponent.builder().header("Error while migrating cache " + mce.cacheName() + " to table " + mce.tableName() + ".", new UiElement[0]).details(details, new UiElement[0]).build().render());
            return 1;
        }
        return DefaultMigrateCacheExceptionHandler.INSTANCE.handle(writer, (Throwable)e);
    }

    public Class<DataStreamerException> applicableException() {
        return DataStreamerException.class;
    }
}

