/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.mixins;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import org.apache.ignite.migrationtools.sql.SqlDdlGenerator;
import picocli.CommandLine;

public class ClassloaderOption {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private ClassLoader clientClassLoader;

    @CommandLine.Option(paramLabel="<jarArchive>", names={"--extra-lib"}, description={"Jar files to add to the classpath. To add multiple jars, specify the option multiple times."})
    public void classloader(Path[] jarFilePaths) {
        URL[] libraries = jarFilePaths != null ? (URL[])Arrays.stream(jarFilePaths).map(p -> {
            if (!p.getFileName().toString().endsWith(".jar") || !Files.isRegularFile(p, new LinkOption[0])) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Invalid value '%s' for option '--extra-lib': path does not point to a jar archive.", p));
            }
            try {
                return p.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Invalid value '%s' for option '--extra-lib': path could not be parsed.", p), (Throwable)e);
            }
        }).toArray(URL[]::new) : new URL[]{};
        this.clientClassLoader = AccessController.doPrivileged(() -> new URLClassLoader(libraries, SqlDdlGenerator.class.getClassLoader()));
    }

    public ClassLoader clientClassLoader() {
        return this.clientClassLoader;
    }
}

