/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.meta;

import java.util.function.Consumer;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.api.NoArg;
import org.apache.ignite.internal.management.meta.MetadataInfoTask;
import org.apache.ignite.internal.management.meta.MetadataListResult;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class MetaListCommand
implements ComputeCommand<IgniteDataTransferObject, MetadataListResult> {
    @Override
    public String description() {
        return "Print list of binary metadata types";
    }

    @Override
    public Class<NoArg> argClass() {
        return NoArg.class;
    }

    @Override
    public Class<MetadataInfoTask> taskClass() {
        return MetadataInfoTask.class;
    }

    @Override
    public void printResult(IgniteDataTransferObject arg, MetadataListResult res, Consumer<String> printer) {
        for (BinaryMetadata m : res.metadata()) {
            printer.accept("typeId=" + MetaListCommand.printInt(m.typeId()) + ", typeName=" + m.typeName() + ", fields=" + m.fields().size() + ", schemas=" + m.schemas().size() + ", isEnum=" + m.isEnum());
        }
    }

    public static String printInt(int val) {
        return "0x" + Integer.toHexString(val).toUpperCase() + " (" + val + ")";
    }
}

