/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.meta;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.NoArg;
import org.apache.ignite.internal.management.meta.MetaDetailsCommandArg;
import org.apache.ignite.internal.management.meta.MetadataListResult;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;

@GridInternal
public class MetadataInfoTask
extends VisorMultiNodeTask<IgniteDataTransferObject, MetadataListResult, MetadataListResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<IgniteDataTransferObject, MetadataListResult> job(IgniteDataTransferObject arg) {
        return new MetadataListJob(arg, this.debug);
    }

    @Override
    protected MetadataListResult reduce0(List<ComputeJobResult> results) {
        if (results.isEmpty()) {
            throw new IgniteException("Empty job results");
        }
        if (results.size() > 1) {
            throw new IgniteException("Invalid job results: " + results);
        }
        if (results.get(0).getException() != null) {
            throw results.get(0).getException();
        }
        return (MetadataListResult)results.get(0).getData();
    }

    public static int typeId(GridKernalContext ctx, int typeId, String typeName) {
        if (typeId != 0) {
            return typeId;
        }
        return ctx.cacheObjects().typeId(typeName);
    }

    private static class MetadataListJob
    extends VisorJob<IgniteDataTransferObject, MetadataListResult> {
        private static final long serialVersionUID = 0L;

        protected MetadataListJob(IgniteDataTransferObject arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected MetadataListResult run(IgniteDataTransferObject arg0) throws IgniteException {
            if (arg0 instanceof NoArg) {
                return new MetadataListResult(((CacheObjectBinaryProcessorImpl)this.ignite.context().cacheObjects()).binaryMetadata());
            }
            MetaDetailsCommandArg arg = (MetaDetailsCommandArg)arg0;
            int typeId = MetadataInfoTask.typeId(this.ignite.context(), arg.typeId(), arg.typeName());
            BinaryMetadata binMeta = ((CacheObjectBinaryProcessorImpl)this.ignite.context().cacheObjects()).binaryMetadata(typeId);
            if (binMeta == null) {
                throw new IgniteException("Failed to get metadata, type not found: " + typeId);
            }
            return new MetadataListResult(Collections.singleton(binMeta));
        }
    }
}

