/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.property;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.property.PropertyGetCommandArg;
import org.apache.ignite.internal.management.property.PropertyOperationResult;
import org.apache.ignite.internal.management.property.PropertySetCommandArg;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class PropertyTask
extends VisorMultiNodeTask<PropertyGetCommandArg, PropertyOperationResult, PropertyOperationResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<PropertyGetCommandArg, PropertyOperationResult> job(PropertyGetCommandArg arg) {
        return new PropertyJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected PropertyOperationResult reduce0(List<ComputeJobResult> results) {
        if (results.isEmpty()) {
            throw new IgniteException("Empty job results");
        }
        if (results.size() > 1) {
            throw new IgniteException("Invalid job results: " + results);
        }
        if (results.get(0).getException() != null) {
            throw results.get(0).getException();
        }
        return (PropertyOperationResult)results.get(0).getData();
    }

    private static class PropertyJob
    extends VisorJob<PropertyGetCommandArg, PropertyOperationResult> {
        private static final long serialVersionUID = 0L;

        protected PropertyJob(@Nullable PropertyGetCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        public SecurityPermissionSet requiredPermissions() {
            return SecurityPermissionSetBuilder.systemPermissions(this.argument(0) instanceof PropertySetCommandArg ? SecurityPermission.ADMIN_WRITE_DISTRIBUTED_PROPERTY : SecurityPermission.ADMIN_READ_DISTRIBUTED_PROPERTY);
        }

        @Override
        protected PropertyOperationResult run(@Nullable PropertyGetCommandArg arg) {
            if (arg == null) {
                throw new IllegalArgumentException("Argument is null");
            }
            DistributedChangeableProperty prop = this.ignite.context().distributedConfiguration().property(arg.name());
            if (prop == null) {
                throw new IllegalArgumentException("Property doesn't not exist [name=" + arg.name() + "]");
            }
            if (!(arg instanceof PropertySetCommandArg)) {
                return new PropertyOperationResult(Objects.toString(prop.get()));
            }
            try {
                prop.propagate(prop.parse(((PropertySetCommandArg)arg).val()));
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            return new PropertyOperationResult(null);
        }
    }
}

