/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class CacheEvictionEntry
implements Message {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private KeyCacheObject key;
    @GridToStringInclude
    private GridCacheVersion ver;
    private boolean near;

    public CacheEvictionEntry() {
    }

    public CacheEvictionEntry(KeyCacheObject key, GridCacheVersion ver, boolean near) {
        this.key = key;
        this.ver = ver;
        this.near = near;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    public boolean near() {
        return this.near;
    }

    @Override
    public short directType() {
        return 97;
    }

    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
        this.key.prepareMarshal(ctx.cacheObjectContext());
    }

    public void finishUnmarshal(GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        this.key.finishUnmarshal(ctx.cacheObjectContext(), ldr);
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeBoolean("near", this.near)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.near = reader.readBoolean("near");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.ver = (GridCacheVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheEvictionEntry.class);
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }
}

