/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckpointEntry {
    private final long cpTs;
    private final WALPointer cpMark;
    private final UUID cpId;
    private volatile SoftReference<GroupStateLazyStore> grpStateLazyStore;

    CheckpointEntry(long cpTs, WALPointer cpMark, UUID cpId, @Nullable Map<Integer, CacheState> cacheGrpStates) {
        this.cpTs = cpTs;
        this.cpMark = cpMark;
        this.cpId = cpId;
        this.grpStateLazyStore = cacheGrpStates == null ? new SoftReference<GroupStateLazyStore>(new GroupStateLazyStore(null)) : new SoftReference<GroupStateLazyStore>(new GroupStateLazyStore(GroupStateLazyStore.remap(cacheGrpStates)));
    }

    public long timestamp() {
        return this.cpTs;
    }

    public UUID checkpointId() {
        return this.cpId;
    }

    public WALPointer checkpointMark() {
        return this.cpMark;
    }

    public Map<Integer, GroupState> groupState(IgniteWriteAheadLogManager wal) throws IgniteCheckedException {
        GroupStateLazyStore store = this.initIfNeeded(wal);
        return store.grpStates;
    }

    private GroupStateLazyStore initIfNeeded(IgniteWriteAheadLogManager wal) throws IgniteCheckedException {
        GroupStateLazyStore store = this.grpStateLazyStore.get();
        if (store == null || IgniteSystemProperties.getBoolean("IGNITE_DISABLE_GRP_STATE_LAZY_STORE", false)) {
            store = new GroupStateLazyStore();
            this.grpStateLazyStore = new SoftReference<GroupStateLazyStore>(store);
        }
        store.initIfNeeded(wal, this.cpMark);
        return store;
    }

    @Nullable
    Map<Integer, GroupState> groupStates() {
        GroupStateLazyStore store = this.grpStateLazyStore.get();
        return store != null ? store.groupStates() : null;
    }

    void fillStore(Map<Integer, GroupState> groupStates) {
        this.grpStateLazyStore = new SoftReference<GroupStateLazyStore>(new GroupStateLazyStore(groupStates));
    }

    public Long partitionCounter(IgniteWriteAheadLogManager wal, int grpId, int part) throws IgniteCheckedException {
        GroupStateLazyStore store = this.initIfNeeded(wal);
        return store.partitionCounter(grpId, part);
    }

    public String toString() {
        return "CheckpointEntry [id=" + this.cpId + ", timestamp=" + this.cpTs + ", ptr=" + this.cpMark + "]";
    }

    public static class GroupStateLazyStore {
        private static final AtomicIntegerFieldUpdater<GroupStateLazyStore> initGuardUpdater = AtomicIntegerFieldUpdater.newUpdater(GroupStateLazyStore.class, "initGuard");
        @Nullable
        private volatile Map<Integer, GroupState> grpStates;
        private final CountDownLatch latch;
        private volatile int initGuard;
        private IgniteCheckedException initEx;

        private GroupStateLazyStore() {
            this(null);
        }

        GroupStateLazyStore(@Nullable Map<Integer, GroupState> stateMap) {
            if (stateMap != null) {
                this.initGuard = 1;
                this.latch = new CountDownLatch(0);
            } else {
                this.latch = new CountDownLatch(1);
            }
            this.grpStates = stateMap;
        }

        private static Map<Integer, GroupState> remap(@NotNull Map<Integer, CacheState> stateRec) {
            if (stateRec.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<Integer, GroupState> grpStates = U.newHashMap(stateRec.size());
            for (Integer grpId : stateRec.keySet()) {
                CacheState recState = stateRec.get(grpId);
                GroupState grpState = new GroupState(recState.size());
                for (int i = 0; i < recState.size(); ++i) {
                    byte partState = recState.stateByIndex(i);
                    if (GridDhtPartitionState.fromOrdinal(partState) != GridDhtPartitionState.OWNING) continue;
                    grpState.addPartitionCounter(recState.partitionByIndex(i), recState.partitionCounterByIndex(i));
                }
                grpStates.put(grpId, grpState);
            }
            return grpStates;
        }

        @Nullable
        Map<Integer, GroupState> groupStates() {
            return this.grpStates;
        }

        private Long partitionCounter(int grpId, int part) {
            assert (this.initGuard != 0) : this.initGuard;
            if (this.initEx != null || this.grpStates == null) {
                return null;
            }
            GroupState state = this.grpStates.get(grpId);
            if (state != null) {
                long cntr = state.counterByPartition(part);
                return cntr < 0L ? null : Long.valueOf(cntr);
            }
            return null;
        }

        private void initIfNeeded(IgniteWriteAheadLogManager wal, WALPointer ptr) throws IgniteCheckedException {
            block14: {
                if (initGuardUpdater.compareAndSet(this, 0, 1)) {
                    try (WALIterator it = wal.replay(ptr);){
                        if (it.hasNextX()) {
                            IgniteBiTuple tup = (IgniteBiTuple)it.nextX();
                            CheckpointRecord rec = (CheckpointRecord)tup.get2();
                            Map<Integer, CacheState> stateRec = rec.cacheGroupStates();
                            this.grpStates = GroupStateLazyStore.remap(stateRec);
                            break block14;
                        }
                        throw new IgniteCheckedException("Failed to find checkpoint record at the given WAL pointer: " + ptr);
                    }
                    catch (IgniteCheckedException e) {
                        this.initEx = e;
                        throw e;
                    }
                    finally {
                        this.latch.countDown();
                    }
                }
                U.await(this.latch);
                if (this.initEx != null) {
                    throw this.initEx;
                }
            }
        }
    }

    public static class GroupState {
        private final int[] parts;
        private final long[] cnts;
        private int idx;

        private GroupState(int partsCnt) {
            this.parts = new int[partsCnt];
            this.cnts = new long[partsCnt];
        }

        GroupState(int[] parts, long[] cnts, int size) {
            this.parts = parts;
            this.cnts = cnts;
            this.idx = size;
        }

        int[] partitionIds() {
            return this.parts;
        }

        long[] partitionCounters() {
            return this.cnts;
        }

        public void addPartitionCounter(int partId, long cntr) {
            if (this.idx == this.parts.length) {
                throw new IllegalStateException("Failed to add new partition to the partitions state (no enough space reserved) [partId=" + partId + ", reserved=" + this.parts.length + "]");
            }
            if (this.idx > 0 && this.parts[this.idx - 1] >= partId) {
                throw new IllegalStateException("Adding partition in a wrong order [prev=" + this.parts[this.idx - 1] + ", cur=" + partId + "]");
            }
            this.parts[this.idx] = partId;
            this.cnts[this.idx] = cntr;
            ++this.idx;
        }

        public long counterByPartition(int partId) {
            int idx = this.indexByPartition(partId);
            return idx >= 0 ? this.cnts[idx] : -1L;
        }

        public int getPartitionByIndex(int idx) {
            return this.parts[idx];
        }

        public int size() {
            return this.idx;
        }

        public int indexByPartition(int partId) {
            return Arrays.binarySearch(this.parts, 0, this.idx, partId);
        }

        public String toString() {
            return "GroupState [cap=" + this.parts.length + ", size=" + this.idx + "]";
        }
    }
}

