/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.CachePartitionDefragmentationManager;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance.ExecuteDefragmentationAction;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance.StopDefragmentationAction;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceWorkflowCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefragmentationWorkflowCallback
implements MaintenanceWorkflowCallback {
    private final CachePartitionDefragmentationManager defrgMgr;
    private final Function<Class<?>, IgniteLogger> logProvider;
    private final FailureProcessor failureProc;

    public DefragmentationWorkflowCallback(Function<Class<?>, IgniteLogger> logProvider, CachePartitionDefragmentationManager defrgMgr, FailureProcessor failureProc) {
        this.defrgMgr = defrgMgr;
        this.logProvider = logProvider;
        this.failureProc = failureProc;
    }

    @Override
    public boolean shouldProceedWithMaintenance() {
        return true;
    }

    @Override
    @NotNull
    public List<MaintenanceAction<?>> allActions() {
        return Collections.singletonList(new StopDefragmentationAction(this.defrgMgr));
    }

    @Nullable
    public MaintenanceAction<Boolean> automaticAction() {
        return new ExecuteDefragmentationAction(this.logProvider, this.defrgMgr, this.failureProc);
    }
}

