/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.typedef.internal.U;

public class BaselineTopologyHistoryItem
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int id;
    private final Collection<Object> consIds;
    private final List<Long> branchingHistory;

    private BaselineTopologyHistoryItem(int id, Collection<Object> consIds, List<Long> branchingHistory) {
        this.id = id;
        this.consIds = consIds;
        this.branchingHistory = branchingHistory;
    }

    public static BaselineTopologyHistoryItem fromBaseline(BaselineTopology blt) {
        if (blt == null) {
            return null;
        }
        ArrayList<Long> fullActivationHistory = new ArrayList<Long>(blt.branchingHistory().size());
        fullActivationHistory.addAll(blt.branchingHistory());
        return new BaselineTopologyHistoryItem(blt.id(), U.arrayList(blt.consistentIds()), fullActivationHistory);
    }

    public int id() {
        return this.id;
    }

    public List<Long> branchingHistory() {
        return this.branchingHistory;
    }
}

