/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcBinaryTypeNamePutRequest
extends JdbcRequest {
    private int typeId;
    private byte platformId;
    private String typeName;

    JdbcBinaryTypeNamePutRequest() {
        super((byte)20);
    }

    public JdbcBinaryTypeNamePutRequest(int typeId, byte platformId, String typeName) {
        super((byte)20);
        this.typeId = typeId;
        this.platformId = platformId;
        this.typeName = typeName;
    }

    public int typeId() {
        return this.typeId;
    }

    public byte platformId() {
        return this.platformId;
    }

    public String typeName() {
        return this.typeName;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeInt(this.typeId);
        writer.writeByte(this.platformId);
        writer.writeString(this.typeName);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.typeId = reader.readInt();
        this.platformId = reader.readByte();
        this.typeName = reader.readString();
    }

    @Override
    public String toString() {
        return S.toString(JdbcBinaryTypeNamePutRequest.class, this);
    }
}

