/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.ServiceLoader;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.processors.platform.PlatformBootstrap;
import org.apache.ignite.internal.processors.platform.PlatformBootstrapFactory;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class PlatformIgnition {
    private static final HashMap<String, PlatformProcessor> instances = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void start(@Nullable String springCfgPath, @Nullable String igniteInstanceName, int factoryId, long envPtr, long dataPtr) {
        if (envPtr <= 0L) {
            throw new IgniteException("Environment pointer must be positive.");
        }
        ClassLoader oldClsLdr = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PlatformProcessor.class.getClassLoader());
        try {
            PlatformBootstrap bootstrap = PlatformIgnition.bootstrap(factoryId);
            bootstrap.init(dataPtr);
            IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext> cfg = PlatformIgnition.configuration(springCfgPath);
            if (igniteInstanceName != null) {
                cfg.get1().setIgniteInstanceName(igniteInstanceName);
            } else {
                igniteInstanceName = cfg.get1().getIgniteInstanceName();
            }
            PlatformProcessor proc = bootstrap.start(cfg.get1(), cfg.get2(), envPtr);
            PlatformProcessor old = instances.put(igniteInstanceName, proc);
            assert (old == null);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClsLdr);
        }
    }

    @Nullable
    public static synchronized PlatformProcessor instance(@Nullable String igniteInstanceName) {
        return instances.get(igniteInstanceName);
    }

    public static synchronized long environmentPointer(@Nullable String igniteInstanceName) {
        PlatformProcessor proc = PlatformIgnition.instance(igniteInstanceName);
        return proc != null ? proc.environmentPointer() : 0L;
    }

    public static synchronized boolean stop(@Nullable String igniteInstanceName, boolean cancel) {
        if (Ignition.stop(igniteInstanceName, cancel)) {
            PlatformProcessor old = instances.remove(igniteInstanceName);
            assert (old != null);
            return true;
        }
        return false;
    }

    public static synchronized void stopAll(boolean cancel) {
        for (PlatformProcessor proc : instances.values()) {
            Ignition.stop(proc.ignite().name(), cancel);
        }
        instances.clear();
    }

    private static IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext> configuration(@Nullable String springCfgPath) {
        if (springCfgPath == null) {
            return new T2<IgniteConfiguration, Object>(new IgniteConfiguration(), null);
        }
        try {
            URL url = U.resolveSpringUrl(springCfgPath);
            return IgnitionEx.loadConfiguration(url);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to instantiate configuration from Spring XML: " + springCfgPath, e);
        }
    }

    private static PlatformBootstrap bootstrap(final int factoryId) {
        PlatformBootstrapFactory factory = AccessController.doPrivileged(new PrivilegedAction<PlatformBootstrapFactory>(){

            @Override
            public PlatformBootstrapFactory run() {
                for (PlatformBootstrapFactory factory : ServiceLoader.load(PlatformBootstrapFactory.class)) {
                    if (factory.id() != factoryId) continue;
                    return factory;
                }
                return null;
            }
        });
        if (factory == null) {
            throw new IgniteException("Interop factory is not found (did you put into the classpath?): " + factoryId);
        }
        return factory.create();
    }

    private PlatformIgnition() {
    }
}

