/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.schema.IndexRebuildCancelToken;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheCompoundFuture;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCachePartitionWorker;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheStat;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorkerFuture;

public class SchemaIndexCacheVisitorImpl
implements SchemaIndexCacheVisitor {
    private final boolean collectStat = IgniteSystemProperties.getBoolean("IGNITE_ENABLE_EXTRA_INDEX_REBUILD_LOGGING", false);
    private final GridCacheContext cctx;
    private final IndexRebuildCancelToken cancelTok;
    protected final GridFutureAdapter<Void> buildIdxFut;
    protected final IgniteLogger log;

    public SchemaIndexCacheVisitorImpl(GridCacheContext<?, ?> cctx, IndexRebuildCancelToken cancelTok, GridFutureAdapter<Void> buildIdxFut) {
        assert (Objects.nonNull(cctx));
        assert (Objects.nonNull(buildIdxFut));
        if (cctx.isNear()) {
            cctx = ((GridNearCacheAdapter)cctx.cache()).dht().context();
        }
        this.cctx = cctx;
        this.buildIdxFut = buildIdxFut;
        this.cancelTok = cancelTok;
        this.log = cctx.kernalContext().log(this.getClass());
    }

    @Override
    public void visit(SchemaIndexCacheVisitorClosure clo) {
        assert (Objects.nonNull(clo));
        List<GridDhtLocalPartition> locParts = this.cctx.topology().localPartitions();
        if (locParts.isEmpty()) {
            this.buildIdxFut.onDone();
            return;
        }
        this.cctx.cache().metrics0().addIndexBuildPartitionsLeftCount(locParts.size());
        this.cctx.cache().metrics0().resetIndexRebuildKeyProcessed();
        this.beforeExecute();
        AtomicInteger partsCnt = new AtomicInteger(locParts.size());
        AtomicBoolean stop = new AtomicBoolean();
        SchemaIndexCacheCompoundFuture buildIdxCompoundFut = new SchemaIndexCacheCompoundFuture();
        for (GridDhtLocalPartition locPart : locParts) {
            GridWorkerFuture<SchemaIndexCacheStat> workerFut = new GridWorkerFuture<SchemaIndexCacheStat>();
            SchemaIndexCachePartitionWorker worker = new SchemaIndexCachePartitionWorker(this.cctx, locPart, stop, this.cancelTok, clo, workerFut, partsCnt);
            workerFut.setWorker(worker);
            buildIdxCompoundFut.add(workerFut);
            this.cctx.kernalContext().pools().buildIndexExecutorService().execute(worker);
        }
        buildIdxCompoundFut.listen(() -> {
            Throwable err = buildIdxCompoundFut.error();
            if (Objects.isNull(err) && this.collectStat && this.log.isInfoEnabled()) {
                try {
                    SchemaIndexCacheStat resStat = new SchemaIndexCacheStat();
                    buildIdxCompoundFut.futures().stream().map(IgniteInternalFuture::result).filter(Objects::nonNull).forEach(resStat::accumulate);
                    this.log.info(this.indexStatStr(resStat));
                }
                catch (Exception e) {
                    this.log.error("Error when trying to print index build/rebuild statistics [cacheName=" + this.cctx.cache().name() + ", grpName=" + this.cctx.group().name() + "]", e);
                }
            }
            this.buildIdxFut.onDone(err);
        });
        buildIdxCompoundFut.markInitialized();
    }

    private String indexStatStr(SchemaIndexCacheStat stat) throws IgniteCheckedException {
        SB res = new SB();
        res.a("Details for cache rebuilding [name=" + this.cctx.cache().name() + ", grpName=" + this.cctx.group().name() + "]");
        res.a(U.nl());
        res.a("   Scanned rows " + stat.scannedKeys() + ", visited types " + stat.typeNames());
        res.a(U.nl());
        IndexProcessor idxProc = this.cctx.kernalContext().indexProcessor();
        for (QueryTypeDescriptorImpl type : stat.types()) {
            res.a("        Type name=" + type.name());
            res.a(U.nl());
            String pk = "_key_PK";
            String tblName = type.tableName();
            res.a("            Index: name=" + pk + ", size=" + idxProc.index(new IndexName(this.cctx.cache().name(), type.schemaName(), tblName, pk)).unwrap(InlineIndex.class).totalCount());
            res.a(U.nl());
            for (GridQueryIndexDescriptor descriptor : type.indexes().values()) {
                long size = idxProc.index(new IndexName(this.cctx.cache().name(), type.schemaName(), tblName, pk)).unwrap(InlineIndex.class).totalCount();
                res.a("            Index: name=" + descriptor.name() + ", size=" + size);
                res.a(U.nl());
            }
        }
        return res.toString();
    }

    protected void beforeExecute() {
    }

    public String toString() {
        return S.toString(SchemaIndexCacheVisitorImpl.class, this);
    }
}

