/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueCLI
extends YarnCLI {
    public static final String QUEUE = "queue";

    public static void main(String[] args) throws Exception {
        QueueCLI cli = new QueueCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)cli, (String[])args);
        cli.stop();
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("status", true, "List queue information about given queue.");
        opts.addOption("help", false, "Displays help for all commands.");
        opts.getOption("status").setArgName("Queue Name");
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            this.printUsage(opts);
            return -1;
        }
        if (cliParser.hasOption("status")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return -1;
            }
            return this.listQueue(cliParser.getOptionValue("status"));
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return 0;
        }
        this.syserr.println("Invalid Command Usage : ");
        this.printUsage(opts);
        return -1;
    }

    @VisibleForTesting
    void printUsage(Options opts) {
        new HelpFormatter().printHelp(QUEUE, opts);
    }

    private int listQueue(String queueName) throws YarnException, IOException {
        int rc;
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        QueueInfo queueInfo = this.client.getQueueInfo(queueName);
        if (queueInfo != null) {
            writer.println("Queue Information : ");
            this.printQueueInfo(writer, queueInfo);
            rc = 0;
        } else {
            writer.println("Cannot get queue from RM by queueName = " + queueName + ", please check.");
            rc = -1;
        }
        writer.flush();
        return rc;
    }

    private void printQueueInfo(PrintWriter writer, QueueInfo queueInfo) {
        writer.print("Queue Name : ");
        writer.println(queueInfo.getQueueName());
        writer.print("\tState : ");
        writer.println(queueInfo.getQueueState());
        DecimalFormat df = new DecimalFormat("#.0");
        writer.print("\tCapacity : ");
        writer.println(df.format(queueInfo.getCapacity() * 100.0f) + "%");
        writer.print("\tCurrent Capacity : ");
        writer.println(df.format(queueInfo.getCurrentCapacity() * 100.0f) + "%");
        writer.print("\tMaximum Capacity : ");
        writer.println(df.format(queueInfo.getMaximumCapacity() * 100.0f) + "%");
        writer.print("\tDefault Node Label expression : ");
        if (null != queueInfo.getDefaultNodeLabelExpression()) {
            writer.println(queueInfo.getDefaultNodeLabelExpression());
        } else {
            writer.println();
        }
        Set nodeLabels = queueInfo.getAccessibleNodeLabels();
        StringBuilder labelList = new StringBuilder();
        writer.print("\tAccessible Node Labels : ");
        for (String nodeLabel : nodeLabels) {
            if (labelList.length() > 0) {
                labelList.append(',');
            }
            labelList.append(nodeLabel);
        }
        writer.println(labelList.toString());
    }
}

