/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import jpt.sun.tools.javac.api.JavacTaskImpl;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.util.ElementFilter;
import jpt30.tools.Diagnostic;
import jpt30.tools.DiagnosticListener;
import jpt30.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.java.source.ElementUtils;
import org.netbeans.modules.java.source.NoJavacHelper;
import org.netbeans.modules.java.source.base.Module;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.ProcessorGenerated;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexEventsTransaction;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class JavaBinaryIndexer
extends BinaryIndexer {
    static final Logger LOG = Logger.getLogger(JavaBinaryIndexer.class.getName());
    private static final int CLEAN_ALL_LIMIT = 1000;

    @Override
    protected void index(Context context) {
        JavaBinaryIndexer.doIndex(context, context.getRootURI(), null);
    }

    static void doIndex(Context context, URL rootURI, Predicate<ClassFile> accept) {
        LOG.log(Level.FINE, "index({0})", rootURI);
        try {
            BinaryAnalyser ba;
            ClassIndexManager cim = ClassIndexManager.getDefault();
            ClassIndexImpl uq = cim.createUsagesQuery(context.getRootURI(), false);
            if (uq == null) {
                return;
            }
            if (context.isAllFilesIndexing() && (ba = uq.getBinaryAnalyser()) != null) {
                BinaryAnalyser.Changes changes = ba.analyse(context, rootURI, accept);
                if (changes.done) {
                    Map<URL, List<URL>> binDeps = IndexingController.getDefault().getBinaryRootDependencies();
                    Map<URL, List<URL>> srcDeps = IndexingController.getDefault().getRootDependencies();
                    Map<URL, List<URL>> peers = IndexingController.getDefault().getRootPeers();
                    ArrayList<ElementHandle<TypeElement>> changed = new ArrayList<ElementHandle<TypeElement>>(changes.changed.size() + changes.removed.size());
                    changed.addAll(changes.changed);
                    changed.addAll(changes.removed);
                    if (!(changes.changed.isEmpty() && changes.added.isEmpty() && changes.removed.isEmpty())) {
                        JavaBinaryIndexer.deleteSigFiles(context.getRootURI(), changed);
                        if (changes.preBuildArgs) {
                            JavaBinaryIndexer.preBuildArgs(JComponent.class.getName(), context.getRootURI());
                        }
                    }
                    Map<URL, Set<URL>> toRebuild = JavaCustomIndexer.findDependent(context.getRootURI(), srcDeps, binDeps, peers, changed, !changes.added.isEmpty(), false);
                    for (Map.Entry<URL, Set<URL>> entry : toRebuild.entrySet()) {
                        context.addSupplementaryFiles(entry.getKey(), (Collection<? extends URL>)entry.getValue());
                    }
                }
            }
        }
        catch (IOException | IllegalArgumentException e) {
            Exceptions.printStackTrace(e);
        }
    }

    private static void deleteSigFiles(URL root, List<? extends ElementHandle<TypeElement>> toRemove) throws IOException {
        File cacheFolder = JavaIndex.getClassFolder(root, false, false);
        if (cacheFolder.exists()) {
            if (toRemove.size() > 1000) {
                FileObjects.deleteRecursively(cacheFolder);
            } else {
                for (ElementHandle<TypeElement> elementHandle : toRemove) {
                    StringBuilder sb = new StringBuilder(FileObjects.convertPackage2Folder(elementHandle.getBinaryName(), File.separatorChar));
                    sb.append('.');
                    sb.append("sig");
                    File f = new File(cacheFolder, sb.toString());
                    f.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preBuildArgs(@NonNull FileObject root, @NonNull FileObject file) throws IOException {
        String relativePath = FileObjects.convertFolder2Package(FileObjects.stripExtension(FileUtil.getRelativePath(root, file)));
        TransactionContext txCtx = TransactionContext.beginTrans().register(FileManagerTransaction.class, FileManagerTransaction.writeThrough()).register(ProcessorGenerated.class, ProcessorGenerated.nullWrite());
        try {
            List<ClassPath.Entry> entries = JavaPlatform.getDefault().getBootstrapLibraries().entries();
            URL[] roots = new URL[1 + entries.size()];
            roots[0] = root.toURL();
            Iterator eit = entries.iterator();
            int i = 1;
            while (eit.hasNext()) {
                roots[i] = ((ClassPath.Entry)eit.next()).getURL();
                ++i;
            }
            JavaBinaryIndexer.preBuildArgs(relativePath, roots);
        }
        finally {
            txCtx.commit();
        }
    }

    private static void preBuildArgs(@NonNull String fqn, URL ... archiveUrls) {
        ClasspathInfo cpInfo = ClasspathInfoAccessor.getINSTANCE().create(ClassPathSupport.createClassPath(archiveUrls), ClassPathSupport.createClassPath(archiveUrls), ClassPath.EMPTY, ClassPath.EMPTY, ClassPath.EMPTY, ClassPath.EMPTY, ClassPath.EMPTY, null, true, true, false, false, false, null);
        class DevNullDiagnosticListener
        implements DiagnosticListener<JavaFileObject> {
            DevNullDiagnosticListener() {
            }

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Diagnostic reported during prebuilding args: {0}", diagnostic.toString());
                }
            }
        }
        JavacTaskImpl jt = JavacParser.createJavacTask(cpInfo, new DevNullDiagnosticListener(), null, null, null, null, null, null, Collections.emptyList());
        jt.enter();
        TypeElement jc = ElementUtils.getTypeElementByBinaryName(jt, fqn);
        if (jc != null) {
            List<ExecutableElement> methods = ElementFilter.methodsIn(jt.getElements().getAllMembers(jc));
            for (ExecutableElement method : methods) {
                List<? extends VariableElement> params = method.getParameters();
                if (params.isEmpty()) continue;
                params.get(0).getSimpleName();
            }
        }
    }

    public static class Factory
    extends BinaryIndexerFactory {
        @Override
        public BinaryIndexer createIndexer() {
            return new JavaBinaryIndexer();
        }

        @Override
        public String getIndexerName() {
            return "java";
        }

        @Override
        public int getIndexVersion() {
            return 15;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rootsRemoved(Iterable<? extends URL> removedRoots) {
            assert (removedRoots != null);
            TransactionContext txCtx = TransactionContext.beginTrans().register(ClassIndexEventsTransaction.class, ClassIndexEventsTransaction.create(false, () -> false));
            try {
                ClassIndexManager cim = ClassIndexManager.getDefault();
                for (URL uRL : removedRoots) {
                    cim.removeRoot(uRL);
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace(e);
            }
            finally {
                try {
                    if (Module.isClosed()) {
                        txCtx.rollBack();
                    } else {
                        txCtx.commit();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
        }

        @Override
        public boolean scanStarted(Context context) {
            try {
                TransactionContext.beginStandardTransaction(context.getRootURI(), false, context::isAllFilesIndexing, context.checkForEditorModifications());
                ClassIndexImpl uq = ClassIndexManager.getDefault().createUsagesQuery(context.getRootURI(), false);
                if (uq == null) {
                    return true;
                }
                if (uq.getState() != ClassIndexImpl.State.NEW) {
                    return true;
                }
                return uq.isValid();
            }
            catch (IOException ioe) {
                JavaIndex.LOG.log(Level.WARNING, "Exception while checking cache validity for root: " + context.getRootURI(), ioe);
                return false;
            }
        }

        @Override
        public void scanFinished(Context context) {
            TransactionContext txCtx = TransactionContext.get();
            assert (txCtx != null);
            try {
                if (context.isCancelled()) {
                    txCtx.rollBack();
                } else {
                    txCtx.commit();
                }
                File classes = JavaIndex.getClassFolder(context.getRootURI(), false, false);
                if (classes.exists() && this.isEmpty(classes)) {
                    classes.delete();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }

        private boolean isEmpty(File dir) {
            String[] content = dir.list();
            return content == null || content.length == 0;
        }

        public static Factory register() {
            return NoJavacHelper.hasWorkingJavac() ? new Factory() : null;
        }
    }
}

