/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.type;

import java.util.BitSet;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.jumpto.common.Models;

final class FilteredListModel
implements ListModel,
Runnable,
ListDataListener {
    private static int NOT_TESTED = -32769;
    private static int EMPTY_VALUE = -32770;
    private static final boolean skipExpensiveAsserts = Boolean.getBoolean("org.openide.explorer.view.LazyListModel.skipExpensiveAsserts");
    private boolean log;
    private ListModel listModel;
    private Models.Filter filter;
    private Object defaultValue;
    private EventListenerList list = new EventListenerList();
    private int originalSize;
    private int size;
    private int[] external;
    private BitSet checked;
    private boolean markDirty;
    static Boolean CREATE;

    private FilteredListModel(ListModel m, Models.Filter f, Object defaultValue) {
        this.listModel = m;
        this.filter = f;
        this.defaultValue = defaultValue;
        m.addListDataListener(this);
    }

    final Models.Filter getFilter() {
        return this.filter;
    }

    private void markDirty() {
        this.markDirty = true;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        if (!this.markDirty) {
            return;
        }
        this.markDirty = false;
        if (this.log) {
            System.err.println("updateYourAssumeptions ();");
        }
        this.updateYourAssumeptions();
    }

    private void notifyRemoval(int from, int to) {
        ListDataEvent ev = new ListDataEvent(this, 2, from, to - 1);
        FilteredListModel.removeInterval(this.external, from, to);
        int cnt = to - from;
        this.size -= cnt;
        this.regenerateCheckedBitSet();
        this.fireChange(ev);
    }

    private void regenerateCheckedBitSet() {
        this.checked = new BitSet(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (this.external[i] < 0) continue;
            this.checked.set(i);
        }
    }

    private int getExternal(int index) {
        if (index == this.size) {
            return this.originalSize;
        }
        if (index < 0) {
            return -1;
        }
        return this.external[index];
    }

    final void updateYourAssumeptions() {
        if (this.external == null) {
            return;
        }
        int i = 0;
        while (i < this.size) {
            while (this.getExternal(i) >= 0 && i < this.size) {
                ++i;
            }
            if (i == this.size) break;
            if (this.getExternal(i) == NOT_TESTED) {
                int minusOneIndex = i - 1;
                while (i < this.size && this.getExternal(i) == NOT_TESTED) {
                    ++i;
                }
                int count = i - minusOneIndex - 1;
                int from = this.getExternal(minusOneIndex) + 1;
                int to = this.getExternal(i);
                assert (from >= 0) : "Value at " + minusOneIndex + "(" + from + ") must be greater than minus one";
                assert (to >= 0) : "Value at " + i + "must be greater than minus one but was: " + to;
                assert (to >= from) : "Must be true: " + to + " >= " + from;
                int howMuch = count - (to - from);
                if (howMuch <= 0) continue;
                this.notifyRemoval(i - howMuch, i);
                i -= howMuch;
                continue;
            }
            int minusTwoIndex = i;
            while (i < this.size && this.getExternal(i) == EMPTY_VALUE) {
                ++i;
            }
            this.notifyRemoval(minusTwoIndex, i);
            i = minusTwoIndex;
        }
        assert (this.externalContraints()) : "Constraints failed";
    }

    private boolean externalContraints() {
        assert (this.external != null) : "Not null";
        assert (this.external.length >= this.size) : "Length " + this.external.length + " >= " + this.size;
        if (!skipExpensiveAsserts) {
            for (int i = 1; i < this.size; ++i) {
                assert (this.external[i - 1] != NOT_TESTED || this.external[i] != EMPTY_VALUE) : "There cannot be empty value after not tested value";
                assert (this.external[i - 1] != EMPTY_VALUE || this.external[i] != NOT_TESTED) : "Not tested cannot immediatelly follow empty value";
                assert (this.external[i] < 0 || this.external[i] > this.external[i - 1]) : "If valid index it has to be greater: " + i;
                assert (this.external[i] < 0 == !this.checked.get(i)) : "external and checked must be consistent: " + i;
            }
        }
        return true;
    }

    private static void removeInterval(int[] array, int index0, int index1) {
        assert (index0 < index1) : "Index1 must be bigger than index0: " + index1 + " > " + index0;
        System.arraycopy(array, index1, array, index0, array.length - index1);
    }

    @NonNull
    static FilteredListModel create(@NonNull ListModel listModel, @NonNull Models.Filter filter, @NullAllowed Object defValue) {
        return new FilteredListModel(listModel, filter, defValue);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.list.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.list.remove(ListDataListener.class, l);
    }

    private void fireChange(ListDataEvent ev) {
        if (this.list.getListenerCount() == 0) {
            return;
        }
        Object[] arr = this.list.getListenerList();
        block5: for (int i = arr.length - 1; i >= 0; i -= 2) {
            ListDataListener l = (ListDataListener)arr[i];
            switch (ev.getType()) {
                case 0: {
                    l.contentsChanged(ev);
                    continue block5;
                }
                case 1: {
                    l.intervalAdded(ev);
                    continue block5;
                }
                case 2: {
                    l.intervalRemoved(ev);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + ev.getType());
                }
            }
        }
    }

    private boolean accepted(int indx, Object[] result) {
        Object v = this.listModel.getElementAt(indx);
        if (this.filter.accept(v)) {
            result[0] = v;
            return true;
        }
        this.markDirty();
        return false;
    }

    private void initialize() {
        if (this.checked == null) {
            this.originalSize = this.listModel.getSize();
            this.size = this.listModel.getSize();
            this.external = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.external[i] = NOT_TESTED;
            }
            this.checked = new BitSet(this.size);
        }
        assert (this.externalContraints()) : "Constraints failed";
    }

    public Object getElementAt(int index) {
        int maxIndex;
        int minIndex;
        this.initialize();
        if (this.log) {
            System.err.println("model.getElementAt (" + index + ");");
        }
        if (this.external[index] >= 0) {
            return this.listModel.getElementAt(this.external[index]);
        }
        if (this.external[index] == EMPTY_VALUE) {
            return this.defaultValue;
        }
        if (CREATE != null && !CREATE.booleanValue()) {
            assert (Thread.holdsLock(CREATE)) : "Only one thread (from tests) can access this";
            return this.defaultValue;
        }
        for (minIndex = index; minIndex >= 0 && this.getExternal(minIndex) < 0; --minIndex) {
        }
        if (this.checked.get(index)) {
            maxIndex = index;
        } else {
            maxIndex = this.checked.nextSetBit(index);
            if (maxIndex == -1 || maxIndex > this.size) {
                maxIndex = this.size;
            }
        }
        int myMinIndex = this.getExternal(minIndex) + 1;
        int myMaxIndex = this.getExternal(maxIndex);
        assert (myMaxIndex >= myMinIndex) : "Must be greater";
        if (myMaxIndex != myMinIndex) {
            Object[] result;
            int myIndex = myMinIndex + (index - minIndex) - 1;
            if (myIndex >= myMaxIndex) {
                myIndex = myMaxIndex - 1;
            }
            if (this.accepted(myIndex, result = new Object[1])) {
                assert (this.external[index] == NOT_TESTED) : "External index " + index + " still needs to be unset: " + this.external[index];
                this.external[index] = myIndex;
                this.checked.set(index);
                return result[0];
            }
            boolean checkBefore = true;
            boolean checkAfter = true;
            int i = 1;
            while (checkAfter || checkBefore) {
                if (checkBefore) {
                    boolean bl = checkBefore = index - i >= minIndex && myIndex - i >= myMinIndex && this.getExternal(index - i) == NOT_TESTED;
                    if (checkBefore && this.accepted(myIndex - i, result)) {
                        this.external[index] = myIndex - i;
                        this.checked.set(index);
                        return result[0];
                    }
                }
                if (checkAfter) {
                    boolean bl = checkAfter = index + i < maxIndex && myIndex + i < myMaxIndex && this.getExternal(index + i) == NOT_TESTED;
                    if (checkAfter && this.accepted(myIndex + i, result)) {
                        this.external[index] = myIndex + i;
                        this.checked.set(index);
                        return result[0];
                    }
                }
                ++i;
            }
        }
        this.markDirty();
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            assert (this.external[i] == NOT_TESTED) : i + " should not be set: " + this.external[i];
            this.external[i] = EMPTY_VALUE;
        }
        this.checked.clear(minIndex + 1, maxIndex);
        assert (this.external[index] == EMPTY_VALUE) : "Should be asigned in the cycle above";
        return this.defaultValue;
    }

    @Override
    public int getSize() {
        this.initialize();
        return this.size;
    }

    @Override
    public void contentsChanged(@NonNull ListDataEvent listDataEvent) {
        if (this.external == null) {
            return;
        }
        this.size = this.originalSize;
        this.external = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.external[i] = NOT_TESTED;
        }
        this.checked = new BitSet(this.size);
        assert (this.externalContraints()) : "Constraints failed";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        int i;
        if (this.external == null) {
            return;
        }
        this.updateYourAssumeptions();
        int first = listDataEvent.getIndex0();
        int end = listDataEvent.getIndex1() + 1;
        int len = end - first;
        int newOriginalSize = this.originalSize + len;
        int newSize = this.size + len;
        int insert = this.findExternalIndex(first);
        int[] newExternal = new int[newSize];
        System.arraycopy(this.external, 0, newExternal, 0, insert);
        for (i = 0; i < len; ++i) {
            newExternal[insert + i] = NOT_TESTED;
        }
        for (i = insert + len; i < newExternal.length; ++i) {
            int v = this.external[i - len];
            newExternal[i] = v < 0 ? v : v + len;
        }
        this.external = newExternal;
        this.size = newSize;
        this.originalSize = newOriginalSize;
        this.regenerateCheckedBitSet();
        this.fireChange(new ListDataEvent(this, 1, insert, insert + len - 1));
        assert (this.externalContraints()) : "Constraints failed";
    }

    private int findExternalIndex(int myIndex) {
        int outIndex = 0;
        for (int i = -1; i < this.size; ++i) {
            outIndex = this.getExternal(i) == NOT_TESTED ? ++outIndex : this.getExternal(i);
            if (outIndex < myIndex) continue;
            return i;
        }
        return this.size;
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.external == null) {
            return;
        }
        this.updateYourAssumeptions();
        int first = listDataEvent.getIndex0();
        int end = listDataEvent.getIndex1() + 1;
        int len = end - first;
        int newOriginalSize = this.originalSize - len;
        int f = this.findExternalIndex(first);
        int e = this.findExternalIndex(end);
        assert (f >= 0) : "First index must be above zero: " + f;
        assert (e >= f) : "End index must be above first: " + f + " <= " + e;
        int outLen = e - f;
        int[] newExternal = (int[])this.external.clone();
        for (int i = e; i < this.size; ++i) {
            int v = this.external[i];
            newExternal[i - outLen] = v < 0 ? v : v - len;
            this.checked.set(i - outLen, v >= 0);
        }
        this.external = newExternal;
        this.size -= outLen;
        this.originalSize = newOriginalSize;
        if (outLen != 0) {
            this.fireChange(new ListDataEvent(this, 2, f, e - 1));
        }
        assert (this.externalContraints()) : "Constraints failed";
    }
}

