/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.util.Map;
import java.util.WeakHashMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

public final class DataNodeUtils {
    private static final RequestProcessor RP = new RequestProcessor("Data System Nodes");
    private static final Map<FileSystem, RequestProcessor> FS_TO_RP = new WeakHashMap<FileSystem, RequestProcessor>();

    private DataNodeUtils() {
    }

    public static RequestProcessor reqProcessor() {
        return RP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestProcessor reqProcessor(FileObject fo) {
        if (fo == null) {
            return RP;
        }
        try {
            FileSystem fs = fo.getFileSystem();
            Map<FileSystem, RequestProcessor> map = FS_TO_RP;
            synchronized (map) {
                RequestProcessor rp = FS_TO_RP.get(fs);
                if (rp == null) {
                    rp = new RequestProcessor("Data System Nodes for " + fs.getDisplayName());
                    FS_TO_RP.put(fs, rp);
                }
                return rp;
            }
        }
        catch (FileStateInvalidException ex) {
            return RP;
        }
    }
}

