/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.text.UserQuestionExceptionHandler;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class CloneableEditorInitializer
implements Runnable {
    private static final Logger EDITOR_LOG = CloneableEditor.LOG;
    private static final Logger LOG = Logger.getLogger(CloneableEditorInitializer.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("org.openide.text Editor Initialization");
    static final Logger TIMER = Logger.getLogger("TIMER");
    static boolean modalDialog;
    static final List<Runnable> edtRequests;
    static final Runnable processPendingEDTRequestsRunnable;
    final CloneableEditor editor;
    final CloneableEditorSupport ces;
    final JEditorPane pane;
    StyledDocument doc;
    private Phase phase;
    private RequestProcessor.Task task;
    private EditorKit kit;
    private JLabel loadingLabel;
    private UserQuestionException uqe;
    boolean provideUnfinishedPane;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitForFinishedInitialization(CloneableEditor editor) {
        assert (SwingUtilities.isEventDispatchThread()) : "Method should only be called from EDT";
        while (true) {
            List<Runnable> list = edtRequests;
            synchronized (list) {
                if (!editor.isInitializationRunning()) {
                    return;
                }
            }
            if (editor.isProvideUnfinishedPane()) {
                return;
            }
            CloneableEditorInitializer.processPendingEDTRequests();
            list = edtRequests;
            synchronized (list) {
                if (!editor.isInitializationRunning()) {
                    return;
                }
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("CEI:Will wait() editor=" + System.identityHashCode(editor) + '\n');
                    }
                    edtRequests.wait(5000L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processPendingEDTRequests() {
        while (true) {
            Runnable request;
            List<Runnable> list = edtRequests;
            synchronized (list) {
                if (edtRequests.isEmpty()) {
                    break;
                }
                request = edtRequests.remove(0);
            }
            if (request == null) continue;
            request.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addEDTRequest(Runnable request) {
        List<Runnable> list = edtRequests;
        synchronized (list) {
            edtRequests.add(request);
            CloneableEditorInitializer.notifyEDTRequestsMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyEDTRequestsMonitor() {
        List<Runnable> list = edtRequests;
        synchronized (list) {
            edtRequests.notifyAll();
        }
    }

    CloneableEditorInitializer(CloneableEditor editor, CloneableEditorSupport ces, JEditorPane pane) {
        this.editor = editor;
        this.ces = ces;
        this.pane = pane;
    }

    void start() {
        boolean success = false;
        try {
            this.kit = this.ces.createEditorKit();
            this.addLoadingLabel();
            this.task = RP.create(this);
            this.task.setPriority(3);
            this.nextPhase();
            success = true;
        }
        finally {
            if (!success) {
                this.cancelInitialization();
            }
        }
    }

    boolean nextPhase() {
        if (this.phase == null) {
            this.phase = Phase.DOCUMENT_OPEN;
        } else {
            int nextOrdinal = this.phase.ordinal() + 1;
            if (nextOrdinal < Phase.values().length) {
                this.phase = Phase.values()[nextOrdinal];
            } else {
                return false;
            }
        }
        boolean success = false;
        try {
            if (this.phase.isRunInEDT()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("CEI:addEDTRequest(): " + this + '\n');
                }
                CloneableEditorInitializer.addEDTRequest(this);
                WindowManager.getDefault().invokeWhenUIReady(processPendingEDTRequestsRunnable);
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("CEI:task.schedule(): " + this + '\n');
                }
                this.task.schedule(0);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.cancelInitialization();
            }
        }
        return true;
    }

    boolean isProvideUnfinishedPane() {
        return this.provideUnfinishedPane;
    }

    void cancelInitialization() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("CEI:cancelInitialization(): " + this + '\n');
        }
        this.editor.markInitializationFinished(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent toClose = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, CloneableEditorInitializer.this.editor);
                if (null == toClose) {
                    toClose = CloneableEditorInitializer.this.editor;
                }
                toClose.close();
            }
        });
    }

    void finishInitialization() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("CEI:finishInitialization(): " + this + '\n');
        }
        this.editor.markInitializationFinished(true);
    }

    private void addLoadingLabel() {
        this.editor.setLayout(new BorderLayout());
        this.loadingLabel = new JLabel(NbBundle.getMessage(CloneableEditor.class, "LBL_EditorLoading"));
        this.loadingLabel.setOpaque(true);
        this.loadingLabel.setHorizontalAlignment(0);
        this.loadingLabel.setBorder(new EmptyBorder(new Insets(11, 11, 11, 11)));
        this.loadingLabel.setVisible(false);
        this.editor.add((Component)this.loadingLabel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        now = System.currentTimeMillis();
        success = false;
        try {
            switch (5.$SwitchMap$org$openide$text$CloneableEditorInitializer$Phase[this.phase.ordinal()]) {
                case 1: {
                    success = this.initDocument();
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 2: {
                    success = this.handleUserQuestionExceptionInEDT();
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 3: {
                    success = this.initActionMapInEDT();
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 4: {
                    success = this.initKit();
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 5: {
                    success = this.setKitAndDocumentToPaneInEDT();
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 6: {
                    success = this.initCustomEditorAndDecorationsInEDT();
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 7: {
                    success = this.firePaneReadyInEDT();
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 8: {
                    this.initAnnotations();
                    success = true;
                    ** break;
lbl37:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong state: " + (Object)this.phase + " for " + this.ces);
                }
            }
        }
        catch (RuntimeException ex) {
            Exceptions.printStackTrace(ex);
            throw ex;
        }
        finally {
            if (!success) {
                this.cancelInitialization();
                return;
            }
        }
        success = false;
        try {
            howLong = System.currentTimeMillis() - now;
            if (CloneableEditorInitializer.TIMER.isLoggable(Level.FINE)) {
                thread = SwingUtilities.isEventDispatchThread() != false ? "EDT" : "RP";
                d = this.doc;
                v0 = who = d == null ? null : d.getProperty("stream");
                if (who == null) {
                    who = this.ces.messageName();
                }
                CloneableEditorInitializer.TIMER.log(Level.FINE, "Open Editor, phase " + (Object)this.phase + ", " + thread + " [ms]", new Object[]{who, howLong});
            }
            success = true;
        }
        finally {
            if (!success) {
                this.cancelInitialization();
            }
        }
        success = false;
        try {
            this.nextPhase();
            success = true;
        }
        finally {
            if (!success) {
                this.cancelInitialization();
            }
        }
    }

    private boolean initDocument() {
        if (EDITOR_LOG.isLoggable(Level.FINE)) {
            EDITOR_LOG.log(Level.FINE, "CloneableEditorInitializer.initDocument() Enter Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(this.editor)) + "] support:[" + Integer.toHexString(System.identityHashCode(this.ces)) + "] Name:" + this.editor.getName());
        }
        try {
            this.ces.prepareDocument();
            this.setDocument(this.ces.openDocument());
            this.ces.getPositionManager().documentOpened(new WeakReference<StyledDocument>(this.doc));
            assert (this.doc != null) : "ces.openDocument() returned null";
            return true;
        }
        catch (UserQuestionException ex) {
            this.uqe = ex;
            return true;
        }
        catch (IOException ex) {
            if (ex.getCause() != null) {
                Exceptions.printStackTrace(ex.getCause());
            }
            return false;
        }
    }

    boolean handleUserQuestionExceptionInEDT() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not EDT";
        if (this.uqe != null) {
            UserQuestionExceptionHandler handler;
            if (EDITOR_LOG.isLoggable(Level.FINE)) {
                EDITOR_LOG.fine("CEI:handleUserQuestionExceptionInEDT: uqe=" + this.uqe + "\n");
            }
            if ((handler = new UserQuestionExceptionHandler(this.ces, this.uqe){

                @Override
                protected void opened(StyledDocument openDoc) {
                    CloneableEditorInitializer.this.setDocument(openDoc);
                }

                @Override
                protected void handleStart() {
                    modalDialog = true;
                }

                @Override
                protected void handleEnd() {
                    modalDialog = false;
                }
            }).handleUserQuestionException()) {
                this.uqe = null;
            } else {
                this.cancelInitialization();
            }
        }
        if (this.doc == null && this.editor.isInitializationRunning()) {
            throw new IllegalStateException("Null document for non-cancelled initialization. uqe=" + this.uqe);
        }
        return this.uqe == null;
    }

    private void setDocument(StyledDocument doc) {
        this.doc = doc;
    }

    private boolean initActionMapInEDT() {
        ActionMap am = this.editor.getActionMap();
        ActionMap paneMap = this.pane.getActionMap();
        this.provideUnfinishedPane = true;
        try {
            am.setParent(paneMap);
        }
        finally {
            this.provideUnfinishedPane = false;
        }
        paneMap.put("cut-to-clipboard", this.getAction("cut-to-clipboard"));
        paneMap.put("copy-to-clipboard", this.getAction("copy-to-clipboard"));
        paneMap.put("delete", this.getAction("delete-next"));
        paneMap.put("paste-from-clipboard", this.getAction("paste-from-clipboard"));
        return true;
    }

    private boolean initKit() {
        if (this.kit instanceof Callable) {
            try {
                ((Callable)((Object)this.kit)).call();
            }
            catch (Exception e) {
                Exceptions.printStackTrace(e);
            }
        }
        return true;
    }

    private Action getAction(String key) {
        if (key == null) {
            return null;
        }
        if (this.kit == null) {
            return null;
        }
        Action[] actions = this.kit.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (!key.equals(actions[i].getValue("Name"))) continue;
            return actions[i];
        }
        return null;
    }

    private void initCustomEditor() {
        if (this.doc instanceof NbDocument.CustomEditor) {
            Component customComponent;
            NbDocument.CustomEditor ce = (NbDocument.CustomEditor)((Object)this.doc);
            this.provideUnfinishedPane = true;
            try {
                customComponent = ce.createEditor(this.pane);
            }
            finally {
                this.provideUnfinishedPane = false;
            }
            if (customComponent == null) {
                throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomEditor may not return null component");
            }
            this.editor.setCustomComponent(customComponent);
            this.editor.add(this.ces.wrapEditorComponent(customComponent), "Center");
        } else {
            JScrollPane noBorderPane = new JScrollPane(this.pane);
            this.pane.setBorder(null);
            this.editor.add(this.ces.wrapEditorComponent(noBorderPane), "Center");
        }
    }

    private void initDecoration() {
        if (this.doc instanceof NbDocument.CustomToolbar) {
            JToolBar customToolbar;
            NbDocument.CustomToolbar ce = (NbDocument.CustomToolbar)((Object)this.doc);
            this.provideUnfinishedPane = true;
            try {
                customToolbar = ce.createToolbar(this.pane);
            }
            finally {
                this.provideUnfinishedPane = false;
            }
            if (customToolbar == null) {
                throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomToolbar may not return null toolbar");
            }
            Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
            customToolbar.setBorder(b);
            this.editor.add((Component)customToolbar, "North");
        }
    }

    private boolean setKitAndDocumentToPaneInEDT() {
        this.provideUnfinishedPane = true;
        try {
            this.pane.setEditorKit(this.kit);
            ((QuietEditorPane)this.pane).setWorking(1);
            this.pane.setDocument(this.doc);
        }
        finally {
            this.provideUnfinishedPane = false;
        }
        return true;
    }

    private boolean initCustomEditorAndDecorationsInEDT() {
        Caret caret;
        this.initCustomEditor();
        this.initDecoration();
        this.editor.remove(this.loadingLabel);
        ((QuietEditorPane)this.pane).setWorking(3);
        int cursorPosition = this.editor.getCursorPosition();
        if (cursorPosition != -1 && (caret = this.pane.getCaret()) != null) {
            caret.setDot(cursorPosition);
        }
        ActionMap actionMap = this.editor.getActionMap();
        ActionMap p = actionMap.getParent();
        actionMap.setParent(null);
        actionMap.setParent(p);
        if (this.shouldRequestFocus(this.pane)) {
            EDITOR_LOG.log(Level.FINE, "requestFocusInWindow {0}", this.pane);
            this.editor.requestFocusInWindow();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloneableEditorInitializer.this.editor.revalidate();
            }
        });
        this.finishInitialization();
        return true;
    }

    private boolean firePaneReadyInEDT() {
        this.ces.firePropertyChange("openedPanes", null, null);
        return true;
    }

    private void initAnnotations() {
        this.ces.ensureAnnotationsLoaded();
    }

    private boolean shouldRequestFocus(Component c) {
        TopComponent active = TopComponent.getRegistry().getActivated();
        while (c != null) {
            if (c == active) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    public String toString() {
        return "phase=" + (Object)((Object)this.phase) + ", editor=" + System.identityHashCode(this.editor);
    }

    static {
        edtRequests = new ArrayList<Runnable>(2);
        processPendingEDTRequestsRunnable = new Runnable(){

            @Override
            public void run() {
                CloneableEditorInitializer.processPendingEDTRequests();
            }
        };
    }

    static enum Phase {
        DOCUMENT_OPEN(false),
        HANDLE_USER_QUESTION_EXCEPTION(true),
        ACTION_MAP(true),
        INIT_KIT(false),
        KIT_AND_DOCUMENT_TO_PANE(true),
        CUSTOM_EDITOR_AND_DECORATIONS(true),
        FIRE_PANE_READY(true),
        ANNOTATIONS(false);

        private final boolean runInEDT;

        private Phase(boolean runInEDT) {
            this.runInEDT = runInEDT;
        }

        public boolean isRunInEDT() {
            return this.runInEDT;
        }
    }
}

