/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg.cs;

import java.io.IOException;
import java.util.List;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.cs.ControllerServiceStateCounts;
import org.apache.nifi.toolkit.client.FlowClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;

public class ControllerServiceUtil {
    public static ControllerServiceStateCounts getControllerServiceStates(FlowClient flowClient, String pgId) throws NiFiClientException, IOException {
        ControllerServicesEntity servicesEntity = flowClient.getControllerServices(pgId);
        if (servicesEntity == null || servicesEntity.getControllerServices() == null) {
            return new ControllerServiceStateCounts();
        }
        List<ControllerServiceEntity> pgCs = servicesEntity.getControllerServices().stream().filter(c -> c.getParentGroupId().equals(pgId)).toList();
        return ControllerServiceUtil.getControllerServiceStates(pgCs);
    }

    private static ControllerServiceStateCounts getControllerServiceStates(List<ControllerServiceEntity> pgCs) throws NiFiClientException {
        ControllerServiceStateCounts states = new ControllerServiceStateCounts();
        if (pgCs.isEmpty()) {
            return states;
        }
        block12: for (ControllerServiceEntity serviceEntity : pgCs) {
            String state;
            switch (state = serviceEntity.getComponent().getState()) {
                case "ENABLED": {
                    states.incrementEnabled();
                    continue block12;
                }
                case "ENABLING": {
                    states.incrementEnabling();
                    continue block12;
                }
                case "DISABLED": {
                    states.incrementDisabled();
                    continue block12;
                }
                case "DISABLING": {
                    states.incrementDisabling();
                    continue block12;
                }
            }
            throw new NiFiClientException("Unexpected controller service state: " + state);
        }
        return states;
    }
}

