/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;

public class SetRegistryClientProperty
extends AbstractNiFiCommand<StringResult> {
    public SetRegistryClientProperty() {
        super("set-reg-client-property", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Sets a property on a registry client.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.REGISTRY_CLIENT_ID.createOption());
        this.addOption(CommandOption.PROPERTY_NAME.createOption());
        this.addOption(CommandOption.PROPERTY_VALUE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String regClientId = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_ID);
        String propertyName = this.getRequiredArg(properties, CommandOption.PROPERTY_NAME);
        String propertyValue = this.getRequiredArg(properties, CommandOption.PROPERTY_VALUE);
        FlowRegistryClientEntity existingRegClient = client.getControllerClient().getRegistryClient(regClientId);
        if (existingRegClient == null) {
            throw new CommandException("Registry client does not exist for id " + regClientId);
        }
        FlowRegistryClientDTO existingRegClientDTO = existingRegClient.getComponent();
        FlowRegistryClientDTO newRegClientDTO = new FlowRegistryClientDTO();
        newRegClientDTO.setId(regClientId);
        newRegClientDTO.setName(existingRegClientDTO.getName());
        newRegClientDTO.setType(existingRegClientDTO.getType());
        newRegClientDTO.setDescription(existingRegClientDTO.getDescription());
        newRegClientDTO.setBundle(existingRegClientDTO.getBundle());
        HashMap<String, String> updatedProperties = new HashMap<String, String>();
        if (existingRegClientDTO.getProperties() != null) {
            updatedProperties.putAll(existingRegClientDTO.getProperties());
        }
        updatedProperties.put(propertyName, propertyValue);
        newRegClientDTO.setProperties(updatedProperties);
        FlowRegistryClientEntity newRegClient = new FlowRegistryClientEntity();
        newRegClient.setComponent(newRegClientDTO);
        newRegClient.setId(regClientId);
        newRegClient.setRevision(existingRegClient.getRevision());
        FlowRegistryClientEntity updatedRegistryClient = client.getControllerClient().updateRegistryClient(newRegClient);
        return new StringResult(updatedRegistryClient.getId(), this.isInteractive());
    }
}

