/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.DigitalSignatureTable;
import org.apache.fontbox.ttf.FontHeaders;
import org.apache.fontbox.ttf.GlyphSubstitutionTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.KerningTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.RandomAccessReadDataStream;
import org.apache.fontbox.ttf.RandomAccessReadUnbufferedDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.VerticalHeaderTable;
import org.apache.fontbox.ttf.VerticalMetricsTable;
import org.apache.fontbox.ttf.VerticalOriginTable;
import org.apache.pdfbox.io.RandomAccessRead;

public class TTFParser {
    private static final Log LOG = LogFactory.getLog(TTFParser.class);
    private boolean isEmbedded = false;

    public TTFParser() {
        this(false);
    }

    public TTFParser(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public TrueTypeFont parse(RandomAccessRead randomAccessRead) throws IOException {
        RandomAccessReadDataStream dataStream = new RandomAccessReadDataStream(randomAccessRead);
        try {
            TrueTypeFont trueTypeFont = this.parse(dataStream);
            return trueTypeFont;
        }
        catch (IOException ex) {
            dataStream.close();
            throw ex;
        }
        finally {
            randomAccessRead.close();
        }
    }

    public TrueTypeFont parseEmbedded(InputStream inputStream) throws IOException {
        this.isEmbedded = true;
        RandomAccessReadDataStream dataStream = new RandomAccessReadDataStream(inputStream);
        try {
            TrueTypeFont trueTypeFont = this.parse(dataStream);
            return trueTypeFont;
        }
        catch (IOException ex) {
            dataStream.close();
            throw ex;
        }
        finally {
            inputStream.close();
        }
    }

    public FontHeaders parseTableHeaders(RandomAccessRead randomAccessRead) throws IOException {
        try (RandomAccessReadUnbufferedDataStream dataStream = new RandomAccessReadUnbufferedDataStream(randomAccessRead);){
            FontHeaders fontHeaders = this.parseTableHeaders(dataStream);
            return fontHeaders;
        }
    }

    private TrueTypeFont createFontWithTables(TTFDataStream raf) throws IOException {
        TrueTypeFont font = this.newFont(raf);
        font.setVersion(raf.read32Fixed());
        int numberOfTables = raf.readUnsignedShort();
        int searchRange = raf.readUnsignedShort();
        int entrySelector = raf.readUnsignedShort();
        int rangeShift = raf.readUnsignedShort();
        for (int i = 0; i < numberOfTables; ++i) {
            TTFTable table = this.readTableDirectory(raf);
            if (table == null) continue;
            if (table.getOffset() + table.getLength() > font.getOriginalDataSize()) {
                LOG.warn("Skip table '" + table.getTag() + "' which goes past the file size; offset: " + table.getOffset() + ", size: " + table.getLength() + ", font size: " + font.getOriginalDataSize());
                continue;
            }
            font.addTable(table);
        }
        return font;
    }

    TrueTypeFont parse(TTFDataStream raf) throws IOException {
        TrueTypeFont font = this.createFontWithTables(raf);
        this.parseTables(font);
        return font;
    }

    TrueTypeFont newFont(TTFDataStream raf) {
        return new TrueTypeFont(raf);
    }

    private void parseTables(TrueTypeFont font) throws IOException {
        for (TTFTable table : font.getTables()) {
            if (table.getInitialized()) continue;
            font.readTable(table);
        }
        boolean hasCFF = font.tables.containsKey("CFF ");
        boolean isOTF = font instanceof OpenTypeFont;
        boolean isPostScript = isOTF ? ((OpenTypeFont)font).isPostScript() : hasCFF;
        HeaderTable head = font.getHeader();
        if (head == null) {
            throw new IOException("'head' table is mandatory");
        }
        HorizontalHeaderTable hh = font.getHorizontalHeader();
        if (hh == null) {
            throw new IOException("'hhea' table is mandatory");
        }
        MaximumProfileTable maxp = font.getMaximumProfile();
        if (maxp == null) {
            throw new IOException("'maxp' table is mandatory");
        }
        PostScriptTable post = font.getPostScript();
        if (post == null && !this.isEmbedded) {
            throw new IOException("'post' table is mandatory");
        }
        if (!isPostScript) {
            if (font.getIndexToLocation() == null) {
                throw new IOException("'loca' table is mandatory");
            }
            if (font.getGlyph() == null) {
                throw new IOException("'glyf' table is mandatory");
            }
        } else if (!isOTF) {
            throw new IOException("True Type fonts using CFF outlines are not supported");
        }
        if (font.getNaming() == null && !this.isEmbedded) {
            throw new IOException("'name' table is mandatory");
        }
        if (font.getHorizontalMetrics() == null) {
            throw new IOException("'hmtx' table is mandatory");
        }
        if (!this.isEmbedded && font.getCmap() == null) {
            throw new IOException("'cmap' table is mandatory");
        }
    }

    FontHeaders parseTableHeaders(TTFDataStream raf) throws IOException {
        FontHeaders outHeaders = new FontHeaders();
        try (TrueTypeFont font = this.createFontWithTables(raf);){
            String[] mandatoryTables;
            boolean isOTFAndPostScript;
            font.readTableHeaders("name", outHeaders);
            font.readTableHeaders("head", outHeaders);
            outHeaders.setOs2Windows(font.getOS2Windows());
            if (font instanceof OpenTypeFont && ((OpenTypeFont)font).isPostScript()) {
                isOTFAndPostScript = true;
                if (((OpenTypeFont)font).isSupportedOTF()) {
                    font.readTableHeaders("CFF ", outHeaders);
                }
            } else {
                if (!(font instanceof OpenTypeFont) && font.tables.containsKey("CFF ")) {
                    outHeaders.setError("True Type fonts using CFF outlines are not supported");
                    FontHeaders fontHeaders = outHeaders;
                    return fontHeaders;
                }
                isOTFAndPostScript = false;
                TTFTable gcid = font.getTableMap().get("gcid");
                if (gcid != null && gcid.getLength() >= 142L) {
                    outHeaders.setNonOtfGcid142(font.getTableNBytes(gcid, 142));
                }
            }
            outHeaders.setIsOTFAndPostScript(isOTFAndPostScript);
            for (String tag : mandatoryTables = new String[]{"head", "hhea", "maxp", this.isEmbedded ? null : "post", isOTFAndPostScript ? null : "loca", isOTFAndPostScript ? null : "glyf", this.isEmbedded ? null : "name", "hmtx", this.isEmbedded ? null : "cmap"}) {
                if (tag == null || font.tables.containsKey(tag)) continue;
                outHeaders.setError("'" + tag + "' table is mandatory");
                FontHeaders fontHeaders = outHeaders;
                return fontHeaders;
            }
        }
        return outHeaders;
    }

    protected boolean allowCFF() {
        return false;
    }

    private TTFTable readTableDirectory(TTFDataStream raf) throws IOException {
        TTFTable table;
        String tag;
        switch (tag = raf.readString(4)) {
            case "cmap": {
                table = new CmapTable();
                break;
            }
            case "glyf": {
                table = new GlyphTable();
                break;
            }
            case "head": {
                table = new HeaderTable();
                break;
            }
            case "hhea": {
                table = new HorizontalHeaderTable();
                break;
            }
            case "hmtx": {
                table = new HorizontalMetricsTable();
                break;
            }
            case "loca": {
                table = new IndexToLocationTable();
                break;
            }
            case "maxp": {
                table = new MaximumProfileTable();
                break;
            }
            case "name": {
                table = new NamingTable();
                break;
            }
            case "OS/2": {
                table = new OS2WindowsMetricsTable();
                break;
            }
            case "post": {
                table = new PostScriptTable();
                break;
            }
            case "DSIG": {
                table = new DigitalSignatureTable();
                break;
            }
            case "kern": {
                table = new KerningTable();
                break;
            }
            case "vhea": {
                table = new VerticalHeaderTable();
                break;
            }
            case "vmtx": {
                table = new VerticalMetricsTable();
                break;
            }
            case "VORG": {
                table = new VerticalOriginTable();
                break;
            }
            case "GSUB": {
                table = new GlyphSubstitutionTable();
                break;
            }
            default: {
                table = this.readTable(tag);
            }
        }
        table.setTag(tag);
        table.setCheckSum(raf.readUnsignedInt());
        table.setOffset(raf.readUnsignedInt());
        table.setLength(raf.readUnsignedInt());
        if (table.getLength() == 0L && !tag.equals("glyf")) {
            return null;
        }
        return table;
    }

    protected TTFTable readTable(String tag) {
        return new TTFTable();
    }
}

