/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class ShadingPatternValidationProcess
extends AbstractProcess {
    private static final Log LOGGER = LogFactory.getLog(ShadingPatternValidationProcess.class);

    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty()) {
            return;
        }
        if (!vPath.isExpectedType(PDShading.class)) {
            context.addValidationError(new ValidationResult.ValidationError("2.1.9", "ShadingPattern validation required at least a PDResources"));
        } else {
            PDShading shadingResource = (PDShading)vPath.peek();
            PDPage page = vPath.getClosestPathElement(PDPage.class);
            this.checkColorSpace(context, page, shadingResource);
            this.checkGraphicState(context, page, shadingResource);
        }
    }

    protected void checkColorSpace(PreflightContext context, PDPage page, PDShading shadingRes) throws ValidationException {
        try {
            PDColorSpace pColorSpace = shadingRes.getColorSpace();
            PreflightConfiguration config = context.getConfig();
            ColorSpaceHelperFactory csFact = config.getColorSpaceHelperFact();
            ColorSpaceHelper csh = csFact.getColorSpaceHelper(context, pColorSpace, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_PATTERN);
            csh.validate();
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Unable to get the color space", (Throwable)e);
            context.addValidationError(new ValidationResult.ValidationError("2.4.4", e.getMessage()));
        }
    }

    protected void checkGraphicState(PreflightContext context, PDPage page, PDShading shadingRes) throws ValidationException {
        COSDictionary resources = (COSDictionary)shadingRes.getCOSObject().getDictionaryObject(COSName.EXT_G_STATE);
        if (resources != null) {
            ContextHelper.validateElement(context, resources, "extgstate-process");
        }
    }
}

