/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.WithScope;
import org.apache.royale.compiler.internal.tree.as.BaseTypedDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.CatchNode;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.FixedChildrenNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.ImportNode;
import org.apache.royale.compiler.internal.tree.as.InterfaceNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.ParameterNode;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.as.WithNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IScopedNode;

public abstract class ExpressionNodeBase
extends FixedChildrenNode
implements IExpressionNode {
    private static final int FLAG_HAS_PARENS = 32768;
    private static final int FLAG_TREAT_AS_PACKAGE = 16384;
    protected int flags;

    public ExpressionNodeBase() {
    }

    protected ExpressionNodeBase(ExpressionNodeBase other) {
        this.flags = other.flags;
        this.setSourcePath(other.getSourcePath());
        this.setLine(other.getLine());
        this.setColumn(other.getColumn());
        this.setStart(other.getAbsoluteStart());
        this.setEnd(other.getAbsoluteEnd());
        this.setEndLine(other.getEndLine());
        this.setEndColumn(other.getEndColumn());
    }

    @Override
    public void normalize(boolean fillInOffsets) {
        this.setChildren(fillInOffsets);
        int childrenSize = this.getChildCount();
        for (int i = 0; i < childrenSize; ++i) {
            IASNode child = this.getChild(i);
            if (!(child instanceof NodeBase)) continue;
            ((NodeBase)child).normalize(fillInOffsets);
        }
        if (fillInOffsets) {
            this.fillInOffsets();
        }
    }

    @Override
    public ASScope getASScope() {
        WithNode withParent;
        ExpressionNodeBase baseExpr;
        IASNode parent;
        ASScope scope = super.getASScope();
        if (scope instanceof WithScope && (parent = (baseExpr = this.getDecorationNode()).getParent()) instanceof WithNode && (withParent = (WithNode)parent).getTargetNode() == baseExpr) {
            return withParent.getASScope();
        }
        return scope;
    }

    @Override
    public IDefinition resolve(ICompilerProject project) {
        return null;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return null;
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        boolean isDynamic = true;
        ITypeDefinition type = this.resolveType(project);
        if (type != null) {
            isDynamic = type.isDynamic();
        }
        if (!isDynamic) {
            String qName = type.getQualifiedName();
            isDynamic = qName.equals("XML") || qName.equals("XMLList");
        }
        return isDynamic;
    }

    @Override
    public ExpressionNodeBase copyForInitializer(IScopedNode scopedNode) {
        ExpressionNodeBase newExpr = this.copy();
        if (newExpr != null) {
            if (scopedNode instanceof NodeBase) {
                NodeBase node = (NodeBase)((Object)scopedNode);
                newExpr.setParent(node);
            }
            newExpr.normalize(false);
        }
        return newExpr;
    }

    @Override
    public boolean hasParenthesis() {
        return (this.flags & 0x8000) != 0;
    }

    protected abstract ExpressionNodeBase copy();

    public Name getMName(ICompilerProject project) {
        return null;
    }

    public void setHasParenthesis(boolean hasParens) {
        this.flags = hasParens ? (this.flags |= 0x8000) : (this.flags &= 0xFFFF7FFF);
    }

    public boolean isPackageReference() {
        ASScope scope;
        String ref;
        if (this.getTreatAsPackage()) {
            return true;
        }
        boolean isPackage = false;
        if (this.getBaseExpression() == null && (ref = this.computeSimpleReference()) != null && (scope = this.getASScope()).isPackageName(ref)) {
            isPackage = true;
        }
        return isPackage;
    }

    public ExpressionNodeBase getBaseExpression() {
        ExpressionNodeBase parent = this.getParentExpression();
        if (parent != null) {
            return parent.getBaseForMemberRef(this);
        }
        return null;
    }

    public boolean inWith() {
        ASScope scope = this.getASScope();
        return scope != null ? scope.isInWith() : false;
    }

    public ExpressionNodeBase getDecorationNode() {
        IASNode current = this;
        while (current.getParent() != null && current.getParent() instanceof ExpressionNodeBase) {
            current = current.getParent();
        }
        return current;
    }

    public final boolean inFilter() {
        for (IASNode parent = this.getParent(); parent != null && !(parent instanceof ScopedBlockNode); parent = parent.getParent()) {
            if (parent.getNodeID() != ASTNodeID.E4XFilterID) continue;
            return true;
        }
        return false;
    }

    protected ExpressionNodeBase getParentExpression() {
        IASNode p = this.getParent();
        return p instanceof ExpressionNodeBase ? (ExpressionNodeBase)p : null;
    }

    String computeSimpleReference() {
        return null;
    }

    IReference computeTypeReference() {
        return null;
    }

    public INamespaceReference computeNamespaceReference() {
        return null;
    }

    boolean isPartOfMemberRef(ExpressionNodeBase e) {
        return false;
    }

    ExpressionNodeBase getBaseForMemberRef(ExpressionNodeBase e) {
        return null;
    }

    boolean isQualifiedExpr(ExpressionNodeBase e) {
        return false;
    }

    ExpressionNodeBase getQualifier(ExpressionNodeBase e) {
        return null;
    }

    boolean isAttributeExpr(ExpressionNodeBase e) {
        return false;
    }

    private boolean getTreatAsPackage() {
        return (this.flags & 0x4000) != 0;
    }

    void setTreatAsPackage(boolean b) {
        this.flags = b ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
    }

    public DependencyType getDependencyType() {
        IASNode parent = this.getParent();
        if (parent instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)parent).getDependencyType();
        }
        if (parent instanceof ClassNode && this == ((ClassNode)parent).getBaseClassNode()) {
            return DependencyType.INHERITANCE;
        }
        if (parent instanceof ContainerNode && parent.getParent() instanceof ClassNode && parent == ((ClassNode)parent.getParent()).getInterfacesNode()) {
            return DependencyType.INHERITANCE;
        }
        if (parent instanceof ContainerNode && parent.getParent() instanceof InterfaceNode && parent == ((InterfaceNode)parent.getParent()).getBaseInterfacesNode()) {
            return DependencyType.INHERITANCE;
        }
        if (parent instanceof ClassNode && this == ((ClassNode)this.getParent()).getNameExpressionNode()) {
            return DependencyType.SIGNATURE;
        }
        NodeBase functionContainingReference = null;
        if (parent instanceof FunctionNode) {
            FunctionNode parentFunction = (FunctionNode)parent;
            if (this == parentFunction.getReturnTypeNode()) {
                functionContainingReference = parentFunction;
            }
        } else if (parent instanceof ParameterNode && this == ((ParameterNode)parent).getTypeNode()) {
            IASNode tempNode = parent.getParent().getParent();
            if (tempNode instanceof FunctionNode) {
                functionContainingReference = (FunctionNode)tempNode;
            } else if (parent.getParent() instanceof CatchNode) {
                return DependencyType.EXPRESSION;
            }
        }
        if (functionContainingReference != null) {
            IASNode outerFunction = functionContainingReference.getAncestorOfType(FunctionNode.class);
            if (outerFunction != null) {
                return DependencyType.EXPRESSION;
            }
            return DependencyType.SIGNATURE;
        }
        if (parent instanceof BaseTypedDefinitionNode && this == ((BaseTypedDefinitionNode)parent).getTypeNode()) {
            assert (!(parent instanceof FunctionNode) && !(parent instanceof ParameterNode));
            FunctionNode functionContainingIdentifier = (FunctionNode)this.getAncestorOfType(FunctionNode.class);
            if (functionContainingIdentifier != null) {
                return DependencyType.EXPRESSION;
            }
            return DependencyType.SIGNATURE;
        }
        if (parent instanceof ImportNode) {
            return null;
        }
        return DependencyType.EXPRESSION;
    }
}

