/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import antlr.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.common.Counter;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceNode;
import org.apache.royale.compiler.internal.tree.as.QualifiedNamespaceExpressionNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.royale.compiler.workspaces.IWorkspace;

public abstract class NodeBase
extends SourceLocation
implements IASNode {
    protected static final IASNode[] emptyNodeArray = new IASNode[0];
    protected IASNode parent = null;

    public static String[] combineAttributes(String[] superAttributes, String[] myAttributes) {
        int i;
        String[] combinedAttributes = new String[superAttributes.length + myAttributes.length];
        for (i = 0; i < superAttributes.length; ++i) {
            combinedAttributes[i] = superAttributes[i];
        }
        for (i = 0; i < myAttributes.length; ++i) {
            combinedAttributes[superAttributes.length + i] = myAttributes[i];
        }
        return combinedAttributes;
    }

    @Override
    public IASNode getParent() {
        return this.parent;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public IASNode getChild(int i) {
        return null;
    }

    @Override
    public IFileSpecification getFileSpecification() {
        ASFileScope fileScope = this.getFileScope();
        IWorkspace w = fileScope.getWorkspace();
        if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
            System.out.println("NodeBase waiting for lock in getFileSpecification");
        }
        IFileSpecification fs = w.getFileSpecification(fileScope.getContainingPath());
        if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
            System.out.println("NodeBase done with lock in getFileSpecification");
        }
        return fs;
    }

    @Override
    public int getSpanningStart() {
        return this.getStart();
    }

    public String getNodeKind() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean contains(int offset) {
        return this.getAbsoluteStart() < offset && this.getAbsoluteEnd() >= offset;
    }

    public boolean looselyContains(int offset) {
        if (this.getAbsoluteStart() == this.getAbsoluteEnd()) {
            if (this.getAbsoluteStart() <= offset) {
                NodeBase containingNode;
                for (containingNode = (NodeBase)this.getParent(); containingNode != null && containingNode.getAbsoluteEnd() <= this.getAbsoluteEnd(); containingNode = (NodeBase)containingNode.getParent()) {
                }
                if (containingNode == null) {
                    return true;
                }
                IASNode succeedingNode = containingNode.getSucceedingNode(this.getAbsoluteEnd());
                if (succeedingNode == null) {
                    return true;
                }
                if (succeedingNode.getAbsoluteStart() >= offset) {
                    return true;
                }
            }
        } else {
            return this.getAbsoluteStart() <= offset && this.getAbsoluteEnd() >= offset;
        }
        return false;
    }

    @Override
    public IASNode getSucceedingNode(int offset) {
        if (this.getAbsoluteEnd() <= offset) {
            return null;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            IASNode child = this.getChild(i);
            if (child.getAbsoluteStart() > offset) {
                return child;
            }
            if (child.getAbsoluteEnd() <= offset) continue;
            return child.getSucceedingNode(offset);
        }
        return null;
    }

    public boolean isTransparent() {
        return false;
    }

    @Override
    public IASNode getContainingNode(int offset) {
        if (!this.contains(offset)) {
            return null;
        }
        IASNode containingNode = this;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            IASNode child = this.getChild(i);
            if (child.getAbsoluteStart() <= offset) {
                if (!child.contains(offset)) continue;
                containingNode = child.getContainingNode(offset);
                if (!(child instanceof NodeBase) || !((NodeBase)child).canContinueContainmentSearch(containingNode, this, i, true)) break;
                continue;
            }
            if (!(child instanceof NodeBase) || !((NodeBase)child).canContinueContainmentSearch(containingNode, this, i, false)) break;
        }
        while (containingNode != null && containingNode instanceof NodeBase && containingNode.isTransparent()) {
            containingNode = containingNode.getParent();
        }
        return containingNode;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public IScopedNode getContainingScope() {
        return (IScopedNode)this.getAncestorOfType(IScopedNode.class);
    }

    protected boolean canContinueContainmentSearch(IASNode containingNode, IASNode currentNode, int childOffset, boolean offsetsStillValid) {
        return false;
    }

    @Override
    public IASNode getAncestorOfType(Class<? extends IASNode> nodeType) {
        IASNode current;
        for (current = this.getParent(); current != null && !nodeType.isInstance(current); current = current.getParent()) {
        }
        if (current != null) {
            return current;
        }
        return null;
    }

    @Override
    public String getPackageName() {
        IASNode current;
        for (current = this.getParent(); current != null && !(current instanceof IPackageNode) && !(current instanceof IMXMLClassDefinitionNode); current = current.getParent()) {
        }
        if (current instanceof IPackageNode) {
            return ((IPackageNode)current).getPackageName();
        }
        if (current instanceof IMXMLClassDefinitionNode) {
            return ((IMXMLClassDefinitionNode)current).getPackageName();
        }
        return null;
    }

    public void startAfter(Token token) {
        if (token instanceof ISourceLocation) {
            this.startAfter((ISourceLocation)((Object)token));
        }
    }

    public final void startAfter(ISourceLocation location) {
        int end = location.getEnd();
        if (end != -1) {
            this.setSourcePath(location.getSourcePath());
            this.setStart(end);
            this.setLine(location.getEndLine());
            this.setColumn(location.getEndColumn());
        }
    }

    public final void startBefore(Token token) {
        if (token instanceof ISourceLocation) {
            this.startBefore((ISourceLocation)((Object)token));
        }
    }

    public final void startBefore(ISourceLocation location) {
        int start = location.getStart();
        if (start != -1) {
            this.setSourcePath(location.getSourcePath());
            this.setStart(start);
            this.setLine(location.getLine());
            this.setColumn(location.getColumn());
        }
    }

    public final void endAfter(Token token) {
        if (token instanceof ISourceLocation) {
            this.endAfter((ISourceLocation)((Object)token));
        }
    }

    public final void endAfter(ISourceLocation location) {
        int end = location.getEnd();
        if (end != -1) {
            this.setEnd(end);
            this.setEndLine(location.getEndLine());
            this.setEndColumn(location.getEndColumn());
        }
    }

    public final void endBefore(Token token) {
        if (token instanceof ISourceLocation) {
            this.endBefore((ISourceLocation)((Object)token));
        }
    }

    public final void endBefore(ISourceLocation location) {
        int start = location.getStart();
        if (start != -1) {
            this.setEnd(start);
            this.setEndLine(location.getLine());
            this.setEndColumn(location.getColumn());
        }
    }

    public final void span(Token token) {
        if (token instanceof ISourceLocation) {
            this.span((ISourceLocation)((Object)token));
        }
    }

    public final void span(Token firstToken, Token lastToken) {
        if (firstToken instanceof ISourceLocation && lastToken instanceof ISourceLocation) {
            this.span((ISourceLocation)((Object)firstToken), (ISourceLocation)((Object)lastToken));
        }
    }

    public final void span(int start, int end, int line, int column) {
        this.span(start, end, line, column, -1, -1);
    }

    public final void span(int start, int end, int line, int column, int endLine, int endColumn) {
        this.setStart(start);
        this.setEnd(end);
        this.setLine(line);
        this.setColumn(column);
        this.setEndLine(endLine);
        this.setEndColumn(endColumn);
    }

    public Collection<ICompilerProblem> runPostProcess(EnumSet<PostProcessStep> set, ASScope containingScope) {
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(10);
        this.normalize(set.contains((Object)PostProcessStep.CALCULATE_OFFSETS));
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE) || set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            this.analyze(set, containingScope, problems);
        }
        return problems;
    }

    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        int childrenSize = this.getChildCount();
        for (int i = 0; i < childrenSize; ++i) {
            IASNode child = this.getChild(i);
            if (!(child instanceof NodeBase)) continue;
            if (child.getParent() == null) {
                ((NodeBase)child).setParent(this);
            }
            ((NodeBase)child).analyze(set, scope, problems);
        }
    }

    protected void swapChildren(NodeBase child, NodeBase target) {
    }

    protected void replaceChild(NodeBase child, NodeBase target) {
    }

    public void normalize(boolean fillInOffsets) {
        int childrenSize = this.getChildCount();
        for (int i = 0; i < childrenSize; ++i) {
            IASNode child = this.getChild(i);
            if (!(child instanceof NodeBase)) continue;
            ((NodeBase)child).setParent(this);
            ((NodeBase)child).normalize(fillInOffsets);
        }
        if (childrenSize == 0) {
            this.setChildren(fillInOffsets);
        }
        if (fillInOffsets) {
            this.fillInOffsets();
        }
    }

    protected void connectedToProjectScope() {
        int childrenSize = this.getChildCount();
        for (int i = 0; i < childrenSize; ++i) {
            IASNode child = this.getChild(i);
            if (!(child instanceof NodeBase)) continue;
            ((NodeBase)child).connectedToProjectScope();
        }
    }

    protected void setChildren(boolean fillInOffsets) {
    }

    protected void fillInOffsets() {
        int numChildren = this.getChildCount();
        if (numChildren > 0) {
            IASNode child;
            int i;
            int start = this.getAbsoluteStart();
            int end = this.getAbsoluteEnd();
            if (start == -1) {
                for (i = 0; i < numChildren; ++i) {
                    child = this.getChild(i);
                    int childStart = child.getAbsoluteStart();
                    if (childStart == -1) continue;
                    if (this.getSourcePath() == null) {
                        this.setSourcePath(child.getSourcePath());
                    }
                    this.setStart(childStart);
                    this.setLine(child.getLine());
                    this.setColumn(child.getColumn());
                    break;
                }
            }
            for (i = numChildren - 1; i >= 0; --i) {
                child = this.getChild(i);
                int childEnd = child.getAbsoluteEnd();
                if (childEnd == -1) continue;
                if (end >= childEnd) break;
                this.setEnd(childEnd);
                this.setEndLine(child.getEndLine());
                this.setEndColumn(child.getEndColumn());
                break;
            }
        }
    }

    public void setParent(NodeBase parent) {
        this.parent = parent;
    }

    public IScopedNode getScopeNode() {
        if (this instanceof IScopedNode && ((IScopedNode)((Object)this)).getScope() != null) {
            return (IScopedNode)((Object)this);
        }
        IASNode parent = this.getParent();
        if (parent != null && parent instanceof NodeBase) {
            return ((NodeBase)parent).getScopeNode();
        }
        return null;
    }

    public String getContainingFilePath() {
        String path = this.getSourcePath();
        if (path != null) {
            return path;
        }
        FileNode fileNode = (FileNode)this.getAncestorOfType(FileNode.class);
        if (fileNode != null) {
            return fileNode.getSourcePath();
        }
        return null;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.buildStringRecursive(sb, 0, false);
        return sb.toString();
    }

    public void buildStringRecursive(StringBuilder sb, int level, boolean skipSrcPath) {
        int i;
        for (i = 0; i < level; ++i) {
            sb.append("  ");
        }
        this.buildOuterString(sb, skipSrcPath);
        sb.append('\n');
        if (skipSrcPath && this instanceof IScopedNode) {
            for (i = 0; i < level + 1; ++i) {
                sb.append("  ");
            }
            sb.append("[Scope]");
            sb.append("\n");
            IScopedNode scopedNode = (IScopedNode)((Object)this);
            IASScope scope = scopedNode.getScope();
            Collection<IDefinition> definitions = scope.getAllLocalDefinitions();
            for (IDefinition def : definitions) {
                for (int i2 = 0; i2 < level + 2; ++i2) {
                    sb.append("  ");
                }
                ((DefinitionBase)def).buildString(sb, false);
                sb.append('\n');
            }
        }
        int n = this.getChildCount();
        for (int i3 = 0; i3 < n; ++i3) {
            NodeBase child = (NodeBase)this.getChild(i3);
            if (child == null) continue;
            child.buildStringRecursive(sb, level + 1, skipSrcPath);
        }
    }

    private void buildOuterString(StringBuilder sb, boolean skipSrcPath) {
        sb.append(this.getNodeKind());
        sb.append("(").append(this.getNodeID().name()).append(")");
        sb.append(' ');
        if (this.buildInnerString(sb)) {
            sb.append(' ');
        }
        if (skipSrcPath) {
            sb.append(this.getOffsetsString());
        } else {
            sb.append(super.toString());
        }
    }

    protected boolean buildInnerString(StringBuilder sb) {
        return false;
    }

    public String getInnerString() {
        StringBuilder sb = new StringBuilder();
        this.buildInnerString(sb);
        return sb.toString();
    }

    public ASFileScope getFileScope() {
        ASScope scope = this.getASScope();
        assert (scope != null);
        while (!(scope instanceof ASFileScope)) {
            scope = scope.getContainingScope();
            assert (scope != null);
        }
        return (ASFileScope)scope;
    }

    protected final OffsetLookup tryGetOffsetLookup() {
        IASNode fileNode = this.getAncestorOfType(IFileNode.class);
        if (fileNode != null) {
            return ((IFileNode)fileNode).getOffsetLookup();
        }
        return null;
    }

    public IWorkspace getWorkspace() {
        return this.getFileScope().getWorkspace();
    }

    public ASScope getASScope() {
        IASScope scope;
        IScopedNode scopeNode = this.getContainingScope();
        IASScope iASScope = scope = scopeNode != null ? scopeNode.getScope() : null;
        while (scope == null && scopeNode != null) {
            scope = (scopeNode = scopeNode.getContainingScope()) != null ? scopeNode.getScope() : null;
        }
        if (scope instanceof TypeScope) {
            BaseDefinitionNode bdn;
            TypeScope typeScope = (TypeScope)scope;
            scope = this instanceof BaseDefinitionNode ? (((BaseDefinitionNode)this).hasModifier(ASModifier.STATIC) ? typeScope.getStaticScope() : typeScope.getInstanceScope()) : ((bdn = (BaseDefinitionNode)this.getAncestorOfType(BaseDefinitionNode.class)) instanceof ClassNode ? typeScope.getStaticScope() : (bdn != null && bdn.hasModifier(ASModifier.STATIC) || bdn instanceof NamespaceNode ? typeScope.getStaticScope() : typeScope.getInstanceScope()));
        }
        ASScope asScope = scope instanceof ASScope ? (ASScope)scope : null;
        return asScope;
    }

    @Override
    public int getStart() {
        OffsetLookup offsetLookup = this.tryGetOffsetLookup();
        if (offsetLookup != null) {
            int absoluteOffset = this.getAbsoluteStart();
            String pathBeforeCaret = offsetLookup.getFilename(absoluteOffset - 1);
            if (pathBeforeCaret != null && pathBeforeCaret.equals(this.getSourcePath())) {
                return offsetLookup.getLocalOffset(absoluteOffset - 1) + 1;
            }
            return offsetLookup.getLocalOffset(absoluteOffset);
        }
        return super.getStart();
    }

    @Override
    public int getEnd() {
        OffsetLookup offsetLookup = this.tryGetOffsetLookup();
        return offsetLookup != null ? offsetLookup.getLocalOffset(super.getEnd() - 1) + 1 : super.getEnd();
    }

    @Override
    public int getAbsoluteStart() {
        return super.getStart();
    }

    @Override
    public int getAbsoluteEnd() {
        return super.getEnd();
    }

    public void collectImportNodes(Collection<IImportNode> importNodes) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            IASNode child = this.getChild(i);
            if (child instanceof IImportNode) {
                importNodes.add((IImportNode)child);
                continue;
            }
            if (child instanceof IScopedNode) continue;
            ((NodeBase)child).collectImportNodes(importNodes);
        }
    }

    public boolean verify() {
        ASTNodeID id = this.getNodeID();
        assert (id != null && id != ASTNodeID.InvalidNodeID && id != ASTNodeID.UnknownID) : "Definition has bad id";
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            NodeBase child = (NodeBase)this.getChild(i);
            assert (child != null) : "Node has null child";
            if (!(child instanceof NamespaceIdentifierNode) && !(child instanceof QualifiedNamespaceExpressionNode)) assert (child.getParent() == this) : "Child node has bad parent";
            child.verify();
        }
        return true;
    }

    private void countNodes() {
        if ((CompilerDiagnosticsConstants.diagnostics & 2) == 2) {
            System.out.println("ASScopeBase incrementing counter for " + this.getClass().getSimpleName());
        }
        Counter counter = Counter.getInstance();
        counter.incrementCount(this.getClass().getSimpleName());
        counter.incrementCount("nodes");
        if ((CompilerDiagnosticsConstants.diagnostics & 2) == 2) {
            System.out.println("ASScopeBase done incrementing counter for " + this.getClass().getSimpleName());
        }
    }
}

