/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.meter;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.foundation.metrics.meter.AbstractPeriodMeter;
import org.apache.servicecomb.foundation.metrics.meter.LatencyDistributionConfig;
import org.apache.servicecomb.foundation.metrics.meter.LatencyScopeConfig;
import org.apache.servicecomb.foundation.metrics.meter.LatencyScopeMeter;

public class LatencyDistributionMeter
extends AbstractPeriodMeter {
    private final List<LatencyScopeMeter> latencyScopeMeters = new ArrayList<LatencyScopeMeter>();

    public LatencyDistributionMeter(Id id, String config) {
        this.id = id;
        LatencyDistributionConfig latencyDistributionConfig = new LatencyDistributionConfig(config);
        for (LatencyScopeConfig scopeConfig : latencyDistributionConfig.getScopeConfigs()) {
            this.latencyScopeMeters.add(new LatencyScopeMeter(id, scopeConfig));
        }
    }

    public void record(long nanoLatency) {
        if (nanoLatency < 0L) {
            return;
        }
        for (LatencyScopeMeter latencyScopeMeter : this.latencyScopeMeters) {
            if (!latencyScopeMeter.update(nanoLatency)) continue;
            return;
        }
    }

    @Override
    public void calcMeasurements(long msNow, long secondInterval) {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        this.calcMeasurements(measurements, msNow, secondInterval);
        this.allMeasurements = measurements;
    }

    @Override
    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        this.latencyScopeMeters.forEach(latencyScopeMeter -> measurements.add(latencyScopeMeter.createMeasurement(msNow)));
    }
}

