/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Optional;
import org.opengis.metadata.spatial.PixelOrientation;

public enum PixelInCell {
    CELL_CENTER("cell center", PixelOrientation.CENTER, 0.0),
    CELL_CORNER("cell corner", PixelOrientation.UPPER_LEFT, -0.5);

    private final String identifier;
    final PixelOrientation orientation;
    final double translationFromCentre;

    private PixelInCell(String identifier, PixelOrientation orientation, double translationFromCentre) {
        this.identifier = identifier;
        this.orientation = orientation;
        this.translationFromCentre = translationFromCentre;
    }

    public Optional<String> identifier() {
        return Optional.of(this.identifier);
    }

    public String[] names() {
        if (this == CELL_CENTER) {
            return new String[]{this.name(), this.identifier, "cell centre"};
        }
        return new String[]{this.name(), this.identifier};
    }
}

