/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.Static;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.resources.Errors;

public final class Numbers
extends Static {
    public static final byte BIG_DECIMAL = 11;
    public static final byte BIG_INTEGER = 10;
    public static final byte FRACTION = 7;
    public static final byte DOUBLE = 9;
    public static final byte FLOAT = 8;
    public static final byte LONG = 6;
    public static final byte INTEGER = 5;
    public static final byte SHORT = 4;
    public static final byte BYTE = 3;
    public static final byte CHARACTER = 2;
    public static final byte BOOLEAN = 1;
    public static final byte OTHER = 0;
    private static final byte DOUBLE_DOUBLE = 12;
    private static final Map<Class<?>, Numbers> MAPPING = new IdentityHashMap(13);
    private final Class<?> primitive;
    private final Class<?> wrapper;
    private final boolean isFloat;
    private final boolean isInteger;
    private final byte size;
    private final byte ordinal;
    private final char internal;
    private final Object nullValue;

    private Numbers(Class<?> type, boolean isFloat, boolean isInteger, byte ordinal) {
        this.wrapper = type;
        this.primitive = this.wrapper;
        this.isFloat = isFloat;
        this.isInteger = isInteger;
        this.size = (byte)-1;
        this.ordinal = ordinal;
        this.internal = (char)76;
        this.nullValue = null;
        if (MAPPING.put(type, this) != null) {
            throw new AssertionError();
        }
    }

    private Numbers(Class<?> primitive, Class<?> wrapper, boolean isFloat, boolean isInteger, byte size, byte ordinal, char internal, Object nullValue) {
        this.primitive = primitive;
        this.wrapper = wrapper;
        this.isFloat = isFloat;
        this.isInteger = isInteger;
        this.size = size;
        this.ordinal = ordinal;
        this.internal = internal;
        this.nullValue = nullValue;
        if (MAPPING.put(primitive, this) != null || MAPPING.put(wrapper, this) != null) {
            throw new AssertionError();
        }
    }

    static char getInternal(Class<?> type) {
        return Numbers.MAPPING.get(type).internal;
    }

    public static boolean isFloat(Class<?> type) {
        Numbers mapping = MAPPING.get(type);
        return mapping != null && mapping.isFloat;
    }

    public static boolean isInteger(Class<?> type) {
        Numbers mapping = MAPPING.get(type);
        return mapping != null && mapping.isInteger;
    }

    public static boolean isNumber(Class<?> type) {
        Numbers mapping = MAPPING.get(type);
        return mapping != null && mapping.isInteger | mapping.isFloat || type != null && Number.class.isAssignableFrom(type);
    }

    public static boolean isNaN(Number value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Double) {
            return ((Double)value).isNaN();
        }
        if (value instanceof Float) {
            return ((Float)value).isNaN();
        }
        if (value instanceof Fraction) {
            return ((Fraction)value).isNaN();
        }
        if (value instanceof DoubleDouble) {
            return ((DoubleDouble)value).isNaN();
        }
        return false;
    }

    public static long round(Number value) {
        long n;
        double v;
        block6: {
            Numbers mapping = MAPPING.get(value.getClass());
            if (mapping == null) break block6;
            switch (mapping.ordinal) {
                case 12: {
                    break;
                }
                case 11: {
                    return ((BigDecimal)value).longValueExact();
                }
                case 10: {
                    return ((BigInteger)value).longValueExact();
                }
                default: {
                    if (!mapping.isInteger) break block6;
                }
            }
            return value.longValue();
        }
        if (Math.abs((v = value.doubleValue()) - (double)(n = Math.round(v))) <= 0.5) {
            return n;
        }
        throw new ArithmeticException(Errors.format((short)12, value, Long.TYPE));
    }

    public static int primitiveBitCount(Class<?> type) throws IllegalArgumentException {
        Numbers mapping = MAPPING.get(type);
        if (mapping != null) {
            byte size = mapping.size;
            if (size >= 0) {
                return size;
            }
        } else if (type == null) {
            return 0;
        }
        throw Numbers.unknownType(type);
    }

    public static <N> Class<N> primitiveToWrapper(Class<N> type) {
        Numbers mapping = MAPPING.get(type);
        return mapping != null ? mapping.wrapper : type;
    }

    public static <N> Class<N> wrapperToPrimitive(Class<N> type) {
        Numbers mapping = MAPPING.get(type);
        return mapping != null ? mapping.primitive : type;
    }

    public static Class<? extends Number> widestClass(Number n1, Number n2) throws IllegalArgumentException {
        return Numbers.widestClass(n1 != null ? n1.getClass() : null, n2 != null ? n2.getClass() : null);
    }

    public static Class<? extends Number> widestClass(Class<? extends Number> c1, Class<? extends Number> c2) throws IllegalArgumentException {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        Numbers m1 = MAPPING.get(c1);
        if (m1 == null) {
            throw Numbers.unknownType(c1);
        }
        Numbers m2 = MAPPING.get(c2);
        if (m2 == null) {
            throw Numbers.unknownType(c2);
        }
        return m1.ordinal >= m2.ordinal ? c1 : c2;
    }

    public static Class<? extends Number> narrowestClass(Number n1, Number n2) throws IllegalArgumentException {
        return Numbers.narrowestClass(n1 != null ? n1.getClass() : null, n2 != null ? n2.getClass() : null);
    }

    public static Class<? extends Number> narrowestClass(Class<? extends Number> c1, Class<? extends Number> c2) throws IllegalArgumentException {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        Numbers m1 = MAPPING.get(c1);
        if (m1 == null) {
            throw Numbers.unknownType(c1);
        }
        Numbers m2 = MAPPING.get(c2);
        if (m2 == null) {
            throw Numbers.unknownType(c2);
        }
        return m1.ordinal < m2.ordinal ? c1 : c2;
    }

    public static Class<? extends Number> narrowestClass(Number value) {
        if (value == null) {
            return null;
        }
        boolean isFloat = false;
        long longValue = value.longValue();
        switch (Numbers.getEnumConstant(value.getClass())) {
            default: {
                double doubleValue = value.doubleValue();
                float floatValue = (float)doubleValue;
                boolean bl = isFloat = Double.doubleToLongBits(floatValue) == Double.doubleToLongBits(doubleValue);
                if (doubleValue != (double)longValue) {
                    return isFloat ? Float.class : Double.class;
                }
            }
            case 6: {
                if ((long)((int)longValue) != longValue) {
                    return isFloat ? Float.class : Long.class;
                }
            }
            case 5: {
                if ((long)((short)longValue) != longValue) {
                    return Integer.class;
                }
            }
            case 4: {
                if ((long)((byte)longValue) == longValue) break;
                return Short.class;
            }
            case 3: 
        }
        return Byte.class;
    }

    public static Number narrowestNumber(Number value) {
        Number candidate;
        if (value == null) {
            return null;
        }
        boolean isFloat = false;
        long longValue = value.longValue();
        switch (Numbers.getEnumConstant(value.getClass())) {
            default: {
                double doubleValue = value.doubleValue();
                float floatValue = (float)doubleValue;
                boolean bl = isFloat = Double.doubleToLongBits(floatValue) == Double.doubleToLongBits(doubleValue);
                if (doubleValue != (double)longValue) {
                    if (isFloat) {
                        candidate = Float.valueOf(floatValue);
                        break;
                    }
                    candidate = doubleValue;
                    break;
                }
            }
            case 6: {
                if ((long)((int)longValue) != longValue) {
                    if (isFloat) {
                        candidate = Float.valueOf(longValue);
                        break;
                    }
                    candidate = longValue;
                    break;
                }
            }
            case 5: {
                if ((long)((short)longValue) != longValue) {
                    candidate = (int)longValue;
                    break;
                }
            }
            case 4: {
                if ((long)((byte)longValue) != longValue) {
                    candidate = (short)longValue;
                    break;
                }
            }
            case 3: {
                candidate = (byte)longValue;
            }
        }
        return value.equals(candidate) ? (Number)value : (Number)candidate;
    }

    public static Number narrowestNumber(String value) throws NumberFormatException {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            return Numbers.narrowestNumber(Double.valueOf(value));
        }
        return Numbers.narrowestNumber(Long.valueOf(value));
    }

    public static <N extends Number> N cast(Number number, Class<N> type) throws IllegalArgumentException {
        if (number == null || number.getClass() == type) {
            return (N)number;
        }
        switch (Numbers.getEnumConstant(type)) {
            case 3: {
                return (N)Byte.valueOf(number.byteValue());
            }
            case 4: {
                return (N)Short.valueOf(number.shortValue());
            }
            case 5: {
                return (N)Integer.valueOf(number.intValue());
            }
            case 6: {
                return (N)Long.valueOf(number.longValue());
            }
            case 8: {
                return (N)Float.valueOf(number.floatValue());
            }
            case 9: {
                return (N)Double.valueOf(number.doubleValue());
            }
            case 7: {
                return (N)Fraction.valueOf(number.doubleValue());
            }
            case 10: {
                BigInteger c = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : BigInteger.valueOf(number.longValue()));
                return (N)c;
            }
            case 11: {
                BigDecimal c = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (Numbers.isInteger(number.getClass()) ? BigDecimal.valueOf(number.longValue()) : new BigDecimal(number.toString())));
                return (N)c;
            }
        }
        if (type.isInstance(number)) {
            return (N)number;
        }
        throw Numbers.unknownType(type);
    }

    public static <N extends Number> N wrap(double value, Class<N> type) throws IllegalArgumentException {
        Number number;
        switch (Numbers.getEnumConstant(type)) {
            case 3: {
                number = (byte)value;
                break;
            }
            case 4: {
                number = (short)value;
                break;
            }
            case 5: {
                number = (int)value;
                break;
            }
            case 6: {
                number = (long)value;
                break;
            }
            case 8: {
                number = Float.valueOf((float)value);
                break;
            }
            case 9: {
                return (N)Double.valueOf(value);
            }
            case 7: {
                return (N)Fraction.valueOf(value);
            }
            case 10: {
                number = BigInteger.valueOf((long)value);
                break;
            }
            case 11: {
                return (N)BigDecimal.valueOf(value);
            }
            default: {
                throw Numbers.unknownType(type);
            }
        }
        if (Double.doubleToLongBits(number.doubleValue()) != Double.doubleToLongBits(value)) {
            throw new IllegalArgumentException(Errors.format((short)12, value, type));
        }
        return (N)number;
    }

    public static <N extends Number> N wrap(long value, Class<N> type) throws IllegalArgumentException {
        Number number;
        switch (Numbers.getEnumConstant(type)) {
            case 3: {
                number = (byte)value;
                break;
            }
            case 4: {
                number = (short)value;
                break;
            }
            case 5: {
                number = (int)value;
                break;
            }
            case 6: {
                return (N)Long.valueOf(value);
            }
            case 8: {
                number = Float.valueOf(value);
                break;
            }
            case 9: {
                number = (double)value;
                break;
            }
            case 7: {
                number = new Fraction((int)value, 1);
                break;
            }
            case 10: {
                return (N)BigInteger.valueOf(value);
            }
            case 11: {
                return (N)BigDecimal.valueOf(value);
            }
            default: {
                throw Numbers.unknownType(type);
            }
        }
        if (number.longValue() != value) {
            throw new IllegalArgumentException(Errors.format((short)12, value, type));
        }
        return (N)number;
    }

    public static <T> T valueOf(String value, Class<T> type) throws IllegalArgumentException, NumberFormatException {
        if (value == null || type == String.class) {
            return (T)value;
        }
        switch (Numbers.getEnumConstant(type)) {
            case 2: {
                return (T)Character.valueOf(value.isEmpty() ? (char)'\u0000' : value.charAt(0));
            }
            case 1: {
                return (T)Boolean.valueOf(value);
            }
            case 3: {
                return (T)Byte.valueOf(value);
            }
            case 4: {
                return (T)Short.valueOf(value);
            }
            case 5: {
                return (T)Integer.valueOf(value);
            }
            case 6: {
                return (T)Long.valueOf(value);
            }
            case 8: {
                return (T)Float.valueOf(value);
            }
            case 9: {
                return (T)Double.valueOf(value);
            }
            case 7: {
                return (T)new Fraction(value);
            }
            case 10: {
                return (T)new BigInteger(value);
            }
            case 11: {
                return (T)new BigDecimal(value);
            }
        }
        throw Numbers.unknownType(type);
    }

    public static <T> T valueOfNil(Class<T> type) {
        Numbers mapping = MAPPING.get(type);
        if (mapping != null) {
            if (type.isPrimitive()) {
                return (T)mapping.nullValue;
            }
        } else if (type != null && type != Object.class) {
            if (type == Map.class) {
                return (T)Collections.EMPTY_MAP;
            }
            if (type == List.class) {
                return (T)Collections.EMPTY_LIST;
            }
            if (type == Queue.class) {
                return (T)CollectionsExt.emptyQueue();
            }
            if (type == SortedSet.class) {
                return (T)Collections.emptySortedSet();
            }
            if (type == NavigableSet.class) {
                return (T)Collections.emptyNavigableSet();
            }
            if (type.isAssignableFrom(Set.class)) {
                return (T)Collections.EMPTY_SET;
            }
            Class<?> element = type.getComponentType();
            if (element != null) {
                return (T)Array.newInstance(element, 0);
            }
        }
        return null;
    }

    public static byte getEnumConstant(Class<?> type) {
        Numbers mapping = MAPPING.get(type);
        return mapping != null ? mapping.ordinal : (byte)0;
    }

    private static IllegalArgumentException unknownType(Class<?> type) {
        return new IllegalArgumentException(Errors.format((short)138, type));
    }

    static {
        new Numbers(DoubleDouble.class, true, false, 12);
        new Numbers(BigDecimal.class, true, false, 11);
        new Numbers(BigInteger.class, false, true, 10);
        new Numbers(Fraction.class, true, false, 7);
        new Numbers(Double.TYPE, Double.class, true, false, 64, 9, 'D', Double.NaN);
        new Numbers(Float.TYPE, Float.class, true, false, 32, 8, 'F', Float.valueOf(Float.NaN));
        new Numbers(Long.TYPE, Long.class, false, true, 64, 6, 'J', 0L);
        new Numbers(Integer.TYPE, Integer.class, false, true, 32, 5, 'I', 0);
        new Numbers(Short.TYPE, Short.class, false, true, 16, 4, 'S', (short)0);
        new Numbers(Byte.TYPE, Byte.class, false, true, 8, 3, 'B', (byte)0);
        new Numbers(Character.TYPE, Character.class, false, false, 16, 2, 'C', Character.valueOf('\u0000'));
        new Numbers(Boolean.TYPE, Boolean.class, false, false, 1, 1, 'Z', Boolean.FALSE);
        new Numbers(Void.TYPE, Void.class, false, false, 0, 0, 'V', null);
    }
}

