/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.access.models;

import jakarta.json.JsonObject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetAcl;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.starter.access.models.AccessFormPage;
import org.apache.sling.starter.access.models.PrincipalPrivilege;

@Model(adaptables={SlingJakartaHttpServletRequest.class})
public class Acl
extends AccessFormPage {
    private List<PrincipalPrivilege> principalPrivilegeList;
    @OSGiService
    public GetAcl getAcl = null;

    public Collection<PrincipalPrivilege> getPrincipals() throws RepositoryException {
        if (this.principalPrivilegeList == null) {
            this.principalPrivilegeList = new ArrayList<PrincipalPrivilege>();
            Session jcrSession = (Session)this.request.getResourceResolver().adaptTo(Session.class);
            PrincipalManager principalManager = ((JackrabbitSession)jcrSession).getPrincipalManager();
            JsonObject acl = this.getAcl.getAcl(jcrSession, this.resource.getPath());
            for (Map.Entry entry : acl.entrySet()) {
                String uid = (String)entry.getKey();
                Principal principal = principalManager.getPrincipal(uid);
                if (principal == null) continue;
                PrincipalPrivilege pi = new PrincipalPrivilege(principal);
                AtomicBoolean allow = new AtomicBoolean(false);
                AtomicBoolean deny = new AtomicBoolean(false);
                JsonObject privilegesObj = ((JsonObject)entry.getValue()).getJsonObject("privileges");
                privilegesObj.values().stream().forEach(item -> {
                    allow.set(allow.get() || ((JsonObject)item).containsKey((Object)"allow"));
                    deny.set(deny.get() || ((JsonObject)item).containsKey((Object)"deny"));
                });
                if (allow.get()) {
                    pi.setAllow(true);
                }
                if (deny.get()) {
                    pi.setDeny(true);
                }
                this.principalPrivilegeList.add(pi);
            }
        }
        return this.principalPrivilegeList;
    }
}

