/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ChildOrderConflictHandler
implements PartialConflictHandler {
    @Override
    public PartialConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            ChildOrderConflictHandler.merge(parent, ours, theirs);
            return PartialConflictHandler.Resolution.MERGED;
        }
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            return PartialConflictHandler.Resolution.THEIRS;
        }
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            ChildOrderConflictHandler.merge(parent, ours, theirs);
            return PartialConflictHandler.Resolution.MERGED;
        }
        return null;
    }

    private static void merge(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        Set<String> theirOrder = SetUtils.toSet(theirs.getValue(Type.NAMES));
        PropertyBuilder<String> merged = PropertyBuilder.array(Type.NAME).assignFrom(theirs);
        for (String ourChild : ours.getValue(Type.NAMES)) {
            if (theirOrder.contains(ourChild)) continue;
            merged.addValue(ourChild);
        }
        for (String child : merged.getValues()) {
            if (parent.hasChildNode(child)) continue;
            merged.removeValue(child);
        }
        parent.setProperty(merged.getPropertyState());
    }

    @Override
    public PartialConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState ours) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            return PartialConflictHandler.Resolution.THEIRS;
        }
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(theirs)) {
            return PartialConflictHandler.Resolution.THEIRS;
        }
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution addExistingNode(NodeBuilder parent, String name, NodeState ours, NodeState theirs) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution changeDeletedNode(NodeBuilder parent, String name, NodeState ours) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution deleteChangedNode(NodeBuilder parent, String name, NodeState theirs) {
        return null;
    }

    @Override
    public PartialConflictHandler.Resolution deleteDeletedNode(NodeBuilder parent, String name) {
        return null;
    }

    private static boolean isChildOrderProperty(PropertyState p) {
        return ":childOrder".equals(p.getName());
    }
}

