/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.schema.Schema;

public class PlaceholderStart
extends Expression {
    private final String name;
    private final String example;

    public PlaceholderStart(Node fromNode, Schema schema, String name, String example) {
        super(fromNode, schema);
        this.name = Preconditions.checkNotNull(name);
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getExample() {
        return this.example;
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitPlaceholderStart(this);
    }

    public PlaceholderStart withSchema(Schema newSchema) {
        return Objects.equal(this.getSchema(), newSchema) ? this : new PlaceholderStart(this, newSchema, this.name, this.example);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof PlaceholderStart && this.equals((PlaceholderStart)that);
    }

    public boolean equals(PlaceholderStart that) {
        return this.equalsExpression(that) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getExample(), that.getExample());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getName(), this.getExample());
    }
}

