/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.NotMemberOf;
import net.sf.oval.internal.util.StringUtils;

public class NotMemberOfCheck
extends AbstractAnnotationCheck<NotMemberOf> {
    private static final long serialVersionUID = 1L;
    private boolean ignoreCase;
    private final List<String> members = Validator.getCollectionFactory().createList(2);
    private transient List<String> membersLowerCase;

    @Override
    public void configure(NotMemberOf constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setIgnoreCase(constraintAnnotation.ignoreCase());
        this.setMembers(constraintAnnotation.value());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("ignoreCase", Boolean.toString(this.ignoreCase));
        messageVariables.put("members", StringUtils.join(this.members, ','));
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public List<String> getMembers() {
        return Validator.getCollectionFactory().createList(this.members);
    }

    private List<String> getMembersLowerCase() {
        List<String> membersLowerCase = this.membersLowerCase;
        if (membersLowerCase == null) {
            membersLowerCase = Validator.getCollectionFactory().createList(this.members.size());
            Locale locale = Validator.getLocaleProvider().getLocale();
            for (String val : this.members) {
                membersLowerCase.add(val.toLowerCase(locale));
            }
            this.membersLowerCase = membersLowerCase;
        }
        return membersLowerCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        if (valueToValidate == null) {
            return true;
        }
        if (this.ignoreCase) {
            return !this.getMembersLowerCase().contains(valueToValidate.toString().toLowerCase(Validator.getLocaleProvider().getLocale()));
        }
        return !this.members.contains(valueToValidate.toString());
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.requireMessageVariablesRecreation();
    }

    public void setMembers(List<String> members) {
        this.members.clear();
        this.members.addAll(members);
        this.membersLowerCase = null;
        this.requireMessageVariablesRecreation();
    }

    public void setMembers(String ... members) {
        this.members.clear();
        Collections.addAll(this.members, members);
        this.membersLowerCase = null;
        this.requireMessageVariablesRecreation();
    }
}

