/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.collect;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.AbstractMapBasedMultiset;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMapBasedMultiset<E> {
    private transient Class<E> type;
    private static final long serialVersionUID = 0L;

    public EnumMultiset(Class<E> type) {
        super(new EnumMap(type));
        this.type = type;
    }

    public EnumMultiset(Iterable<E> elements) {
        this(EnumMultiset.findClass(elements));
        Iterables.addAll(this, elements);
    }

    private static <E extends Enum<E>> Class<E> findClass(Iterable<E> elements) {
        Iterator<E> iterator = elements.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        return ((Enum)iterator.next()).getDeclaringClass();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.type);
        Serialization.writeMultiset(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Class localType;
        stream.defaultReadObject();
        this.type = localType = (Class)stream.readObject();
        this.setBackingMap(new EnumMap(this.type));
        Serialization.populateMultiset(this, stream);
    }
}

