/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.io;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.io.LineProcessor;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

public class LineWriter
extends Writer {
    protected final Appendable out;
    private final LineProcessor processor;

    public LineWriter(Appendable out) {
        Preconditions.checkNotNull(out);
        this.out = out;
        this.processor = new LineProcessor(){

            @Override
            protected void processLine(String line, String end) throws IOException {
                LineWriter.this.processLine(line, end);
            }
        };
    }

    protected void processLine(String line, String end) throws IOException {
        this.out.append(line).append(end);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.processor.process(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
    }

    public void finish() throws IOException {
        this.processor.finish();
        this.flush();
    }
}

