/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.alerts;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.util.ClassMap;

public class ConfigurableAlertPolicy
implements AlertPolicy {
    ClassMap<Alert, Alert.Severity> map = ClassMap.create();
    private boolean treatWarningsAsErrors = false;
    private static final long serialVersionUID = 1L;

    public void setSeverity(Class<? extends Alert> cls, Alert.Severity severity) {
        this.map.put(cls, Preconditions.checkNotNull(severity));
    }

    public boolean getTreatWarningsAsErrors() {
        return this.treatWarningsAsErrors;
    }

    public void setTreatWarningsAsErrors(boolean value) {
        this.treatWarningsAsErrors = value;
    }

    @Override
    public Alert.Severity getSeverity(Alert alert) {
        Alert.Severity result = this.map.get(alert.getClass());
        if (result == null) {
            result = alert.getDefaultSeverity();
        }
        if (this.treatWarningsAsErrors && result == Alert.Severity.WARNING) {
            result = Alert.Severity.ERROR;
        }
        return result;
    }
}

