/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.alerts;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSet;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.io.RuntimeIOException;
import java.io.IOException;

public class PrintingAlertSink
implements AlertSink {
    private final AlertPolicy alertPolicy;
    private final boolean verboseEnabled;
    private final Appendable out;

    public PrintingAlertSink(AlertPolicy alertPolicy, boolean verboseEnabled, Appendable out) {
        this.alertPolicy = Preconditions.checkNotNull(alertPolicy);
        this.verboseEnabled = verboseEnabled;
        this.out = Preconditions.checkNotNull(out);
    }

    @Override
    public void add(Alert alert) {
        try {
            if (this.verboseEnabled || this.alertPolicy.getSeverity(alert) != Alert.Severity.INFO) {
                this.out.append(alert.toString()).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void addAll(AlertSet alertSet) {
        for (Alert alert : alertSet) {
            this.add(alert);
        }
    }
}

