/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.autotag.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tiles.autotag.model.TemplateClass;

public class TemplateSuite {
    private String name;
    private String documentation;
    private Map<String, TemplateClass> templateClasses;

    public TemplateSuite(String name, String documentation) {
        this(name, documentation, null);
    }

    public TemplateSuite(String name, String documentation, Iterable<? extends TemplateClass> classes) {
        this.name = name;
        this.documentation = documentation;
        this.templateClasses = new LinkedHashMap<String, TemplateClass>();
        if (classes != null) {
            for (TemplateClass templateClass : classes) {
                this.templateClasses.put(templateClass.getName(), templateClass);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void addTemplateClass(TemplateClass clazz) {
        this.templateClasses.put(clazz.getName(), clazz);
    }

    public Collection<TemplateClass> getTemplateClasses() {
        return this.templateClasses.values();
    }

    public TemplateClass getTemplateClassByName(String name) {
        return this.templateClasses.get(name);
    }

    public String toString() {
        return "TemplateSuite [name=" + this.name + ", documentation=" + this.documentation + ", templateClasses=" + this.templateClasses + "]";
    }
}

